/*
 * Copyright (c) 2016-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */


#ifndef SDD_HAL_H
#define SDD_HAL_H

#include "sonos_stdint.h"
#include "hwevent_queue_user_api.h"


#define SDD_MAJOR_NUMBER    (213)
#define SDD_DEVICE_NAME	    "sdd"
#define SDD_DEVICE_NODE	    "/dev/"SDD_DEVICE_NAME

#define SDD_MAX_NUM_SENSORS 20

#define SDD_VERSION		(1)

struct SDD_READ {
	enum HWEVTQ_EventInfo capzonea;
	enum HWEVTQ_EventInfo capzoneb;
	enum HWEVTQ_EventInfo capzonec;
	enum HWEVTQ_EventInfo capzonem;
};

struct sdd_info {
	uint32_t instance;
	uint16_t version;
	int num_sensors;
	uint32_t parasitic_cap[SDD_MAX_NUM_SENSORS];
	uint16_t raw_cap[SDD_MAX_NUM_SENSORS];
	uint16_t mod_idac[SDD_MAX_NUM_SENSORS];
	uint16_t comp_idac[SDD_MAX_NUM_SENSORS];
	uint16_t sense_clk_div[SDD_MAX_NUM_SENSORS];
	uint16_t mod_clk_div[SDD_MAX_NUM_SENSORS];
	uint16_t signal[SDD_MAX_NUM_SENSORS];
	uint16_t baseline[SDD_MAX_NUM_SENSORS];
	uint16_t max_sig[SDD_MAX_NUM_SENSORS];
};

struct ble_settings {
	uint32_t instance;
	int enable;
};

struct capsense_settings {
	uint32_t instance;
	int enable;
};

struct ble_carrier_settings {
	uint32_t instance;
	uint8_t channel;
	int transmit;
};

#define SDD_GET_VERSION             _IOR(SDD_MAJOR_NUMBER,  0,  uint32_t)
#define SDD_SET_REPEAT_TIME         _IOR(SDD_MAJOR_NUMBER,  1,  uint32_t)
#define SDD_GET_REPEAT_TIME         _IOR(SDD_MAJOR_NUMBER,  2,  uint32_t)
#define SDD_GET_INFO                _IOWR(SDD_MAJOR_NUMBER, 3,  struct sdd_info)
#define SDD_ERASE_PSOC              _IOW(SDD_MAJOR_NUMBER,  4,  uint32_t)
#define SDD_PROGRAM_PSOC            _IOW(SDD_MAJOR_NUMBER,  5,  uint32_t)
#define SDD_GEN_INTR                _IOW(SDD_MAJOR_NUMBER,  6,  uint32_t)
#define SDD_GET_CMOD_CAP            _IOWR(SDD_MAJOR_NUMBER, 7,  uint32_t)
#define SDD_GET_RTC_TIME            _IOWR(SDD_MAJOR_NUMBER, 8,  uint64_t)
#define SDD_ENABLE_BLE              _IOW(SDD_MAJOR_NUMBER,  9,  struct ble_settings)
#define SDD_SET_BLE_CARRIER_TX      _IOW(SDD_MAJOR_NUMBER,  10, struct ble_carrier_settings)
#define SDD_SET_CAPSENSE_ENABLE     _IOW(SDD_MAJOR_NUMBER,  11, struct capsense_settings)
#define SDD_GET_CAPSENSE_ENABLE     _IOWR(SDD_MAJOR_NUMBER, 12, struct capsense_settings)
#endif
