/*
 * Copyright (c) 2021, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef _RT9120S_H
#define _RT9120S_H

#define RT9120S_SW_RESET_REG		0x40
#define RT9120S_TDM_RX_L_REG		0xA1
#define RT9120S_TDM_RX_R_REG		0xA2
#define RT9120S_SYS_CTL_REG		0x05
#define RT9120S_ERR_RPT_REG		0x10

#define RT9120S_SW_RESET_VAL		0x80
#define RT9120S_TDM_RX_L_PAUSE_VAL	0x08
#define RT9120S_TDM_RX_R_PAUSE_VAL	0x0C
#define RT9120S_SYS_CTL_PLAY_VAL	0x80
#define RT9120S_SYS_CTL_PAUSE_VAL	0xC0
#define RT9120S_ERR_CLR_VAL		0x0
#define RT9120S_ERR_MASK_VAL		0x30

#define RT9120S_NUM_OF_REGS	165
static const int reg_size[RT9120S_NUM_OF_REGS] = {
	2, 1, 1, -1, 1, 1, 1, 1, 1, 2, 1, 1, 1, -1, -1, -1,
	1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1,
	3, 3, 3, 3, 3, 3, 3, 3, 3, -1, 3, 3, 3, 3, 4, -1,
	1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 1, -1, 1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	1, 1, 1, 1, 1
};

int rt9120s_init(void);
void rt9120s_exit(void);

#endif
