/* Copyright (c) 2020, Sonos, Inc.  All rights reserved */
#ifndef PSOC_RPMSG_H
#define PSOC_RPMSG_H

#include "touchpad_log_entry.h"

enum psoc_rpmsg_cmd {
	PSOC_RPMSG_PROGRAM,
	PSOC_RPMSG_CHECK,
	PSOC_RPMSG_INDIRECT_READ,
	PSOC_RPMSG_INDIRECT_WRITE,
	PSOC_RPMSG_TOUCHPAD_LOG,
	PSOC_RPMSG_VAR_SET,
	PSOC_RPMSG_VAR_GET,
};

enum psoc_m33_var_id {
	PSOC_RPMSG_VAR_ID_SWIPE_DISTANCE,
	PSOC_RPMSG_VAR_ID_PRESS_HOLD_TIME,
	PSOC_RPMSG_VAR_ID_DOUBLE_TAP_TIME,
	PSOC_RPMSG_VAR_ID_DISABLE_INTERRUPT,
	PSOC_RPMSG_VAR_ID_ENABLE_INTERRUPT,
};

enum psoc_rpmsg_program_mode {
	PSOC_RPMSG_PROGRAM_START,
	PSOC_RPMSG_PROGRAM_STOP,
};

enum psoc_rpmsg_resp_status {
	PSOC_RPMSG_SUCCESS = 0,
	PSOC_RPMSG_FAILED,
};

struct psoc_indirect_cmd_msg {
	uint8_t	 psoc;
	uint8_t	 index;
	uint8_t	 flags;
	uint8_t	 len;
	uint32_t param;
	uint8_t	 wrdata[4];
};

struct psoc_indirect_rsp_msg {
	uint8_t data[4];
};

struct touchpad_log_rsp_msg {
	struct touchpad_log_entry tle;
	uint32_t empty;
};

struct var_setget {
	uint8_t psoc;
	uint8_t id;
	uint8_t unused0;
	uint8_t unused1;
	uint32_t val;
};

union psoc_msg_data {
	uint8_t byte;
	struct psoc_indirect_cmd_msg cmd;
	struct psoc_indirect_rsp_msg rsp;
	struct touchpad_log_rsp_msg log;
	struct var_setget var;
};

struct psoc_rpmsg {
	struct imx_rpmsg_head header;
	uint8_t ret_val;
	union psoc_msg_data data;
};

#endif
