/*
 * Copyright (c) 2016-2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef _PCM1864_H
#define _PCM1864_H

#define PCM1864_PGA_CH1L	0x01
#define PCM1864_PGA_CH1R	0x02
#define PCM1864_PGA_CH2L	0x03
#define PCM1864_PGA_CH2R	0x04
#define PCM1864_PGA_CONF	0x05
#define PCM1864_ADC1_L		0x06
#define PCM1864_ADC1_R		0x07
#define PCM1864_ADC2_L		0x08
#define PCM1864_ADC2_R		0x09

#define PCM1864_TDM_FMT		0x0b
#define PCM1864_TDM_MODE	0x0c
#define PCM1864_TDM_OFFSET	0x0d

#define PCM1864_GPIO0_GPIO1	0x10
#define PCM1864_GPIO2_GPIO3	0x11

#define PCM1864_DIGMIC		0x1a

#define PCM1864_IRQ_POL		0x62

#define PCM1864_PWR_CTL		0x70
#define PCM1864_DSP_CTL		0x71
#define PCM1864_PWR_STATE	0x72
#define PCM1864_FS_STATE	0x73
#define PCM1864_BCLK_STATE	0x74

#define PCM1864_PGA_SMOOTH	0x80
#define PCM1864_PGA_LINK	0x40
#define PCM1864_PGA_DPGA_CLIP	0x20
#define PCM1864_PGA_MAX_ATT(x)	((x & 0x3) << 3)
#define PCM1864_PGA_START_ATT(x)	((x & 3) << 1)
#define PCM1864_PGA_AGC_EN	0x01

#define PCM1864_ADC_POL		0x80
#define PCM1864_ADC_IN1_DIFF	0x10
#define PCM1864_ADC_IN2_DIFF	0x20

#define PCM1864_TDM_FMT_WLEN(x)	((x & 0x3) << 2)
#define PCM1864_TDM_FMT_SEL(x)	(x & 0x3)

#define PCM1864_TDM_MODE_CHAN(x)	(x & 0x3)


#define PCM1864_GPIO0_POL	0x08
#define PCM1864_GPIO0_FUNC_MIC	0x01
#define PCM1864_GPIO1_POL	(0x08 << 4)
#define PCM1864_GPIO1_FUNC_MIC	(0x01 << 4)
#define PCM1864_GPIO2_POL	0x08
#define PCM1864_GPIO2_FUNC_CLK	0x01
#define PCM1864_GPIO3_POL	(0x08 << 4)
#define PCM1864_GPIO3_FUNC_IRQ	(0x02 << 4)

#define PCM1864_DIGMIC_EN	0x01
#define PCM1864_DIGMIC_4CH	0x02
#define PCM1864_DIGMIC_IN0	0x10
#define PCM1864_DIGMIC_IN1	0x40

#define PCM1864_IRQ_WIDTH(x)	(x & 0x3)
#define PCM1864_IRQ_POL_HI	0x10
#define PCM1864_IRQ_POL_OD	0x20

#define PCM1864_PWR_DIGI	0x01
#define PCM1864_PWR_SLEEP	0x02
#define PCM1864_PWR_ADC		0x04

#define PCM1864_DSP_FLT		0x20
#define PCM1864_DSP_HPF		0x10

#define PCM1864_CONF_PGA	( \
		PCM1864_PGA_SMOOTH |		 \
		PCM1864_PGA_LINK |		 \
		PCM1864_PGA_START_ATT(0x3)	 \
	)

#define PCM1864_CONF_PGA_VAL	(0x28)

#define PCM1864_CONF_ADC1_L	( \
		PCM1864_ADC_IN1_DIFF		 \
	)
#define PCM1864_CONF_ADC1_R	( \
		PCM1864_ADC_IN1_DIFF		 \
	)
#define PCM1864_CONF_ADC2_L	( \
		PCM1864_ADC_IN2_DIFF		 \
	)
#define PCM1864_CONF_ADC2_R	( \
		PCM1864_ADC_IN2_DIFF		 \
	)

#define PCM1864_CONF_TDM_FMT	( \
		PCM1864_TDM_FMT_WLEN(0x0) |	 \
		PCM1864_TDM_FMT_SEL(0x3)	 \
	)
#define PCM1864_CONF_TDM_MODE	( \
		PCM1864_TDM_MODE_CHAN(0x1)	 \
	)

#define PCM1864_CONF_TDM_OFFSET(id) ( \
		((id == 1) ? 0x80 : 0x00)	 \
	)

#define PCM1864_CONF_GPIO0_GPIO1 ( \
		PCM1864_GPIO0_FUNC_MIC |	 \
		PCM1864_GPIO1_FUNC_MIC		 \
	)

#define PCM1864_CONF_GPIO2_GPIO3 ( \
		PCM1864_GPIO2_FUNC_CLK |	 \
		PCM1864_GPIO3_FUNC_IRQ		 \
	)

#define PCM1864_CONF_DIGMIC ( \
		PCM1864_DIGMIC_EN |		 \
		PCM1864_DIGMIC_4CH |		 \
		PCM1864_DIGMIC_IN1		 \
	)

#define PCM1864_CONF_IRQ_POL	( \
		PCM1864_IRQ_WIDTH(0x3)		 \
	)

#define PCM1864_CONF_DSP_CTL	( \
		PCM1864_DSP_FLT |		 \
		PCM1864_DSP_HPF			 \
	)

int pcm1864_init(void);
void pcm1864_exit(void);

#endif
