/*
 * Copyright (c) 2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 */

#ifndef PCM1690_H
#define PCM1690_H

#define PCM1690_REG_BASE		0x40
#define PCM1690_NUM_REGS		0x10

#define PCM1690_REG_40H		0x40
#define PCM1690_MRST			0x80
#define PCM1690_SRST			0x40
#define PCM1690_AMUTE(x)		((x & 0x0f) << 2)
#define PCM1690_SRDA(x)			((x & 0x03))
#define PCM1690_REG_41H		0x41
#define PCM1690_PSMDA			0x80
#define PCM1690_FMTDA(x)		((x & 0x0f))
#define PCM1690_REG_42H		0x42
#define PCM1690_OPEDA(x)		((x & 0x0f) << 4)
#define PCM1690_FLT(x)			((x & 0x0f))
#define PCM1690_REG_REVDA		0x43
#define PCM1690_REVDA(x)		((x & 0xff))
#define PCM1690_REG_MUTDA	0x44
#define PCM1690_MUTDA(x)		((x & 0xff))
#define PCM1690_REG_ZERO	0x45
#define PCM1690_ZERO(x)			((x & 0xff))
#define PCM1690_REG_46H		0x46
#define PCM1690_DAMS			0x80
#define PCM1690_DEMP(x)			((x & 0x03) << 4)
#define PCM1690_AZR(x)			((x & 0x03) << 1)
#define PCM1690_ZREV			0x01
#define PCM1690_REG_ATDA_BASE	0x48

extern int pcm1690_i2c_init(void);
extern void pcm1690_i2c_exit(void);
extern int pcm1690_dac_smute_i2c(int on);
extern int pcm1690_dac_reset_i2c(int on);

#endif
