/*
 * Copyright (C) 2017-2018 Sonos Inc. All Rights Reserved
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef MTK_M4_H
#define MTK_M4_H

#include "smu_ipc.h"

#define CM4_MAJOR_NUMBER (144)
#define CM4_CLASS_NAME   "coprocessor"
#define CM4_DEVICE_NAME  "cm4"
#define CM4_DEVICE_NODE  "/dev/"CM4_DEVICE_NAME

#define CM4_VERSION      (1)
#define CM4_GET_VERSION  _IOR(CM4_MAJOR_NUMBER, 0, uint32_t)

int cm4_ipc_send_packet(IPC_PKT_TYPE pkt_type, uint8_t *payload, uint32_t len);
void cm4_register_ipc_rcv_callback(void (*ipc_callback)(uint8_t *payload), IPC_PKT_TYPE pkt_type);
void cm4_unregister_ipc_rcv_callback(IPC_PKT_TYPE pkt_type);

#endif
