/*
 * Copyright (c) 2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef IRRX_DRV_H
#define IRRX_DRV_H


#define IR_MAJOR_NUMBER  (244)
#define IR_DEVICE_NAME   "ir"
#define IR_DEVICE_NODE   "/dev/"IR_DEVICE_NAME
#define IR_VERSION       (1)

#define IR_GET_VERSION   _IOR(IR_MAJOR_NUMBER, 0, uint32_t)

#define IRRX_PULSE_COUNT (128)
#define MTK_IRRX_CONFIG      (IRRX_CH_END_15 | IRRX_CH_CHKEN | IRRX_CH_IGB0 \
			| IRRX_CH_IGSYN | IRRX_CH_HWIR)
#define MTK_IRRX_SAPERIOD    (0xB980F)
#define MTK_IRRX_THRESHOLD   (0x0301)


#define IR_RECORD_ON                (1)
#define IR_RECORD_OFF               (0)
#define IR_SYMBOL_MAX_NUM_EDGES     (150)

#endif
