/*
 * Copyright (c) 2016-2017, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * Header file for the MT8521p audio peripheral dispatcher
 */

#ifndef _MT8521P_AUDIO_H_
#define _MT8521P_AUDIO_H_
#include "mt8521p-afe.h"
#include "lla.h"

enum buf_slice_state {
	BUF_SLICE_DONE = 0,
	BUF_SLICE_COMMIT,
	BUF_SLICE_ERASED
};

struct audio_buffer_slice {
	void			*addr;
	enum buf_slice_state	state;
};

#define COMPLETION_HIST_SIZE	10
#define I2S_TX_BUFFER_CNT	64
#define SPDIF_TX_BUFFER_CNT	64
#define MTK_DMA_PTR_SLOP(buf_size)	(buf_size - 20)

struct audio_params {
	u32 enable;
	u32 lla_type;
	u32 frames_per_second;
	u32 channel_len;
	u32 channel_mask;
	u32 channels_per_frame;
	u32 frames_per_buffer;
	u32 buffer_cnt;
	u32 virtual_fps;
	u32 ring_cnt;
	u8  invert_fs;
	u8  uses_mclk;
	u8  sync_tx_rx;
};

struct audio_priv {
	u32			last_tx_buf;
	u32			last_rx_buf;
	u32			last_tx_ptr;
	u32			last_rx_ptr;
	u32			last_erase;
	u32			zero_comp_cnt;
	u32			tx_irq_cnt;
	u32			rx_irq_cnt;
	u32			tx_completion_hist[COMPLETION_HIST_SIZE];
	u32			rx_completion_hist[COMPLETION_HIST_SIZE];
	u32			completion_discont_cnt;
	union {
		struct audio_buffer_slice i2s[I2S_TX_BUFFER_CNT];
		struct audio_buffer_slice spdif[SPDIF_TX_BUFFER_CNT];
	} slices;
	enum afe_spdifrx_port	port;
	struct afe_memif_config	mem_config;
	spinlock_t		spdif_rx_csb_lock;
	u32			spdif_rx_csb_valid;
	u8			spdif_rx_csb_data[24];
	struct lla_shared	*tx_shared;
	struct lla_shared	*rx_shared;
	struct lla_dev		tx_lla_dev;
	struct lla_dev		rx_lla_dev;
	struct device		*dev;
	struct proc_dir_entry	*parent;
	struct tasklet_struct	erase_task;
	struct delayed_work	rx_sync_search_work;
	wait_queue_head_t	tx_poll_event;
	wait_queue_head_t	rx_poll_event;
	u32 (*irq_callback)(struct audio_priv *, u32 status);
	void (*do_zero)(struct audio_priv *, u32, u32);
	void (*exit)(struct audio_priv *);
	struct audio_params *tx_params;
	struct audio_params *rx_params;
	struct audio_priv *next;
};

void audio_register_dev(struct audio_priv *cb_struct);
void audio_unregister_dev(struct audio_priv *cb_struct);
void audio_tx_zero_work(unsigned long data);
struct audio_params *audio_get_params(enum lla_dev_type type);
int audio_init(void);
void audio_exit(void);
#endif
