/*
 * Copyright (c) 2021, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef _MA2304_H
#define _MA2304_H


#define MA2304_POWER_CTL_REG            0x0000
#define MA2304_STANDBY_CTL_REG          0x0002
#define MA2304_DSP_CTL_REG              0x0005
#define MA2304_ERR_PIN_REG              0x0006
#define MA2304_I2S_CTL_REG              0x0010
#define MA2304_TDM_INPUT_MAP0_REG       0x0012
#define MA2304_TDM_INPUT_MAP1_REG       0x0013
#define MA2304_ERR_1_REG                0x011A
#define MA2304_ERR_2_REG                0x011B
#define MA2304_ERR_3_REG                0x011C
#define MA2304_ERR_4_REG                0x011D
#define MA2304_ERR_CLR_REG              0x0104
#define MA2304_GATE_DRIVE_REG           0x0141
#define MA2304_AMP_STARTUP_TIME_REG     0x0142

#define MA2304_POWER_CTL_VAL            0x24
#define MA2304_IN_STANDBY               0x10
#define MA2304_OUT_OF_STANDBY           0x00
#define MA2304_DSP_CTL_VAL              0x08
#define MA2304_ERR_VAL                  0x02
#define MA2304_I2S_CTL_VAL              0x10
#define MA2304_TDM_INPUT_MAP0_VAL       0x01
#define MA2304_TDM_INPUT_MAP1_VAL       0x00
#define MA2304_ERR_CLR_VAL_1            0x00
#define MA2304_ERR_CLR_VAL_2            0x03
#define MA2304_AMP_STARTUP_TIME_VAL     0x4D
#define MA2304_FAULTS_MASK_PLL          0x5fffffff
#define MA2304_FAULTS_MASK_OCP          0xfffffafa

int ma2304_init(void);
void ma2304_exit(void);

#endif
