/*
 * Copyright (c) 2021, Sonos, Inc.
 *
 * SPDX-License-Identifier:	 GPL-2.0
 */

#ifndef _LTR311_ALS_H_
#define _LTR311_ALS_H_

#define LTR311_DRIVER_NAME "ltr311"
#define LTR311_POLLING_DELAY_MS (2000)
#define LTR311_MAX_CLIENTS (1)
#define LTR311_R_MANUFAC_ID_EXPECTED 0x06
#define LTR311_R_PART_ID_EXPECTED 0x90

#define LTR311_ALS_GAIN_FACTOR 		(0x00)
#define LTR311_ALS_INT_TIME_SCALE	(0x00)
#define LTR311_ALS_MEAS_RATE_SCALE	(0x00)
#define LTR311_ALS_INT_TIME_STEP	(0x32)
#define LTR311_ALS_MEAS_TIME_STEP	(0xFF)
#define LTR311_COMP_COEFF_DEFAULT	(10000)

#define LTR311_ALS_INT_TIME_00 78
#define LTR311_ALS_INT_TIME_01 39
#define LTR311_ALS_INT_TIME_1X 20

#define LTR311_LUX_CALC_ALS_VAL_COEFF 612
#define LTR311_LUX_CALC_IR_VAL_COEFF 68

#define LTR311_R_ALS_AVERAGING		(0x7F)
#define LTR311_R_ALS_CONTR			(0x80)
#define LTR311_R_RESET				(0x81)
#define LTR311_R_ALS_TIME_SCALE		(0x85)
#define LTR311_R_ALS_INT_TIME_STEPS	(0x86)
#define LTR311_R_ALS_MRR_STEPS		(0x87)
#define LTR311_R_ALS_STATUS			(0x88)
#define LTR311_R_ALS_DATA_LSB		(0x8B)
#define LTR311_R_ALS_DATA_MSB		(0x8C)
#define LTR311_R_ALS_IR_DATA_LSB	(0x8D)
#define LTR311_R_ALS_IR_DATA_MSB	(0x8E)
#define LTR311_R_IR_ENABLE			(0x95)
#define LTR311_R_PD_ENABLE			(0x98)
#define LTR311_R_INTERRUPT			(0xA0)
#define LTR311_R_INTERRUPT_PERSIST	(0xA1)
#define LTR311_R_ALS_THRES_HIGH_LSB	(0xAA)
#define LTR311_R_ALS_THRES_HIGH_MSB	(0xAB)
#define LTR311_R_ALS_THRES_LOW_LSB	(0xAC)
#define LTR311_R_ALS_THRES_LOW_MSB	(0xAD)
#define LTR311_R_PART_ID			(0xAE)
#define LTR311_R_MANUFAC_ID			(0xAF)
#define LTR311_R_INTERNAL_CONTR1	(0xB4)
#define LTR311_R_INTERNAL_CONTR2	(0xBC)
#define LTR311_R_ALS_CONFIG1		(0xBE)
#define LTR311_R_ALS_CONFIG2		(0xC1)
#define LTR311_R_ALS_CONFIG3		(0xC2)
#define LTR311_R_IR_OS_LASER_CODE	(0xC5)
#define LTR311_R_ALS_OS_LASER_CODE	(0xC7)
#define LTR311_R_ALS_OS_EFUSE_CODE	(0xD5)
#define LTR311_R_IR_OS_EFUSE_CODE	(0xD7)
#define LTR311_R_ALS_SIGN_READ		(0xE6)

#endif
