/*
 * Copyright (c) 2014-2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * SONOS LED control module header
 */

#ifndef LEDCTL_H
#define LEDCTL_H

#define LEDCTL_MAJOR_NUMBER	(210)
#define LEDCTL_DEVICE_NAME	"ledctl"
#define LEDCTL_DEVICE_NODE	"/dev/"LEDCTL_DEVICE_NAME
#define LEDCTL_VERSION		(1)

#define LEDCTL_GET_VERSION	_IOR(LEDCTL_MAJOR_NUMBER, 0, uint32_t)
#define LEDCTL_SET_FEEDBACK	_IOW(LEDCTL_MAJOR_NUMBER, 1, uint8_t)
#define LEDCTL_FEEDBACK_CLR	_IOW(LEDCTL_MAJOR_NUMBER, 2, struct led_step)

#ifdef __KERNEL__
#include "sonos_led.h"
struct ledctl_hw_pins {
	uint32_t	red;
	uint32_t	green;
	uint32_t	blue;
	uint32_t	white;
};

struct ledctl_hw_ops {
	int	(*update) (struct led_step *);
	int	(*scale) (struct led_step *);
};

int ledctl_init(void);
void ledctl_exit(void);
void ledctl_hw_register(struct ledctl_hw_ops *ops);
void ledctl_hw_unregister(void);
int ledctl_update(struct led_pattern *pattern);

int ledctl_max(struct led_step *step);
int ledctl_is_white(struct led_step *step);
struct led_step ledctl_diff(struct led_step *step1, struct led_step *step2);
int ledctl_same_color(struct led_step *step1, struct led_step *step2);
int ledctl_is_same(struct led_step *step1, struct led_step *step2);

enum feedback_state {
	FB_STOP = -1,
	FB_OFF = 0,
	FB_ON,
	FB_SCHED
};
#endif

#endif
