/*
 * Copyright (c) 2022, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef _IS31FL3195_H_
#define _IS31FL3195_H_


#define IS31FL3195_NUM_REGS		0x50

#define IS31FL3195_REG_PRODUCT_ID	0x00

#define IS31FL3195_REG_SHUTDOWN_CONTROL	0x01
#define IS31FL3195_SHUTDOWN_CONTROL	0xF1

#define IS31FL3195_REG_OPERATING_MODE	0x02
#define IS31FL3195_OPERATING_MODE	0xF1

#define IS31FL3195_REG_CHARGE_PUMP_MODE	0x03
#define IS31FL3195_CHARGE_PUMP_MODE	0x20

#define IS31FL3195_REG_CHARGE_PUMP_HR	0x04
#define IS31FL3195_CHARGE_PUMP_HR	0x30

#define IS31FL3195_REG_CURRENT_BAND	0x05
#define IS31FL3195_CURRENT_BAND		0xFF

#define IS31FL3195_REG_HOLD_FUNCTION	0x06
#define IS31FL3195_HOLD_P1_ENABLE_BIT	0x02
#define IS31FL3195_HOLD_P1_AT_T2_BIT	0x01
#define IS31FL3195_HOLD_P4_ENABLE_BIT	0x80
#define IS31FL3195_HOLD_P4_AT_T2_BIT	0x40

#define IS31FL3195_REG_P1_STATE		0x0C
#define IS31FL3195_REG_P2_STATE		0x0D
#define IS31FL3195_REG_P3_STATE		0x0E
#define IS31FL3195_REG_P4_STATE		0x0F
#define IS31FL3195_PATTERN_RUNNING_BIT	0x80
#define IS31FL3195_COLOR_STATE_SHIFT	4
#define IS31FL3195_COLOR_STATE_MASK	0x03
#define IS31FL3195_TIME_STATE_MASK	0x03

#define IS31FL3195_REG_P1_COLOR_1_G	0x10
#define IS31FL3195_REG_P1_COLOR_1_R	0x11
#define IS31FL3195_REG_P1_COLOR_1_B	0x12

#define IS31FL3195_REG_P4_COLOR_1_W	0x40

#define IS31FL3195_REG_P1_SET_TS_T1	0x19
#define IS31FL3195_REG_P2_SET_TS_T1	0x29
#define IS31FL3195_REG_P3_SET_TS_T1	0x39
#define IS31FL3195_REG_P4_SET_TS_T1	0x49
#define IS31FL3195_T1_SHIFT		4

#define IS31FL3195_REG_P1_SET_T2_T3	0x1A
#define IS31FL3195_REG_P2_SET_T2_T3	0x2A
#define IS31FL3195_REG_P3_SET_T2_T3	0x3A
#define IS31FL3195_REG_P4_SET_T2_T3	0x4A
#define IS31FL3195_T3_SHIFT		4

#define IS31FL3195_REG_P1_COLOR_ENABLE	0x1C
#define IS31FL3195_REG_P2_COLOR_ENABLE	0x2C
#define IS31FL3195_REG_P3_COLOR_ENABLE	0x3C
#define IS31FL3195_REG_P4_COLOR_ENABLE	0x4C
#define IS31FL3195_ENABLE_COLOR_1	0x01

#define IS31FL3195_REG_P1_COLOR_CYCLES	0x1D
#define IS31FL3195_REG_P2_COLOR_CYCLES	0x2D
#define IS31FL3195_REG_P3_COLOR_CYCLES	0x3D
#define IS31FL3195_REG_P4_COLOR_CYCLES	0x4D
#define IS31FL3195_SINGLE_COLOR_CYCLE	0x15

#define IS31FL3195_REG_P1_NXT		0x1E
#define IS31FL3195_REG_P2_NXT		0x2E
#define IS31FL3195_REG_P3_NXT		0x3E
#define IS31FL3195_REG_P4_NXT		0x4E
#define IS31FL3195_NXT_MTPLT_SHIFT	4
#define IS31FL3195_NXT_INIT		0x10

#define IS31FL3195_REG_P1_LOOP		0x1F
#define IS31FL3195_REG_P2_LOOP		0x2F
#define IS31FL3195_REG_P3_LOOP		0x3F
#define IS31FL3195_REG_P4_LOOP		0x4F
#define IS31FL3195_DONT_LOOP		0x01

#define IS31FL3195_REG_COLOR_UPDATE	0x50
#define IS31FL3195_COLOR_UPDATE		0xC5

#define IS31FL3195_REG_P1_UPDATE	0x51
#define IS31FL3195_REG_P2_UPDATE	0x52
#define IS31FL3195_REG_P3_UPDATE	0x53
#define IS31FL3195_REG_P4_UPDATE	0x54
#define IS31FL3195_PATTERN_UPDATE	0xC5

#define IS31FL3195_REG_RESET		0x5F
#define IS31FL3195_RESET		0xC5

#endif
