/*
 * Copyright (c) 2014-2017, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * Copyright (C) 2013 Freescale Semiconductor, Inc.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2.  This program  is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#ifndef IMX_SPDIF_H
#define IMX_SPDIF_H

#define SPDIF_SCR		0x0
#define SPDIF_SRCD		0x4
#define SPDIF_SRPC		0x8
#define SPDIF_SIE		0xc
#define SPDIF_SIS		0x10
#define SPDIF_SIC		0x10
#define SPDIF_SRL		0x14
#define SPDIF_SRR		0x18
#define SPDIF_SRCSH		0x1c
#define SPDIF_SRCSL		0x20
#define SPDIF_SRU		0x24
#define SPDIF_SRQ		0x28
#define SPDIF_STL		0x2C
#define SPDIF_STR		0x30
#define SPDIF_STCSCH		0x34
#define SPDIF_STCSCL		0x38
#define SPDIF_SRFM		0x44
#define SPDIF_STC		0x50

#define SPDIF_SCR_RXFIFO_CTL_OFFSET		23
#define SPDIF_SCR_RXFIFO_CTL_MASK		(1 << SPDIF_SCR_RXFIFO_CTL_OFFSET)
#define SPDIF_SCR_RXFIFO_CTL_ZERO		(1 << SPDIF_SCR_RXFIFO_CTL_OFFSET)
#define SPDIF_SCR_RXFIFO_OFF_OFFSET		22
#define SPDIF_SCR_RXFIFO_OFF_MASK		(1 << SPDIF_SCR_RXFIFO_OFF_OFFSET)
#define SPDIF_SCR_RXFIFO_OFF			(1 << SPDIF_SCR_RXFIFO_OFF_OFFSET)
#define SPDIF_SCR_RXFIFO_RST_OFFSET		21
#define SPDIF_SCR_RXFIFO_RST_MASK		(1 << SPDIF_SCR_RXFIFO_RST_OFFSET)
#define SPDIF_SCR_RXFIFO_RST			(1 << SPDIF_SCR_RXFIFO_RST_OFFSET)
#define SPDIF_SCR_RXFIFO_FSEL_OFFSET		19
#define SPDIF_SCR_RXFIFO_FSEL_MASK		(0x3 << SPDIF_SCR_RXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_RXFIFO_FSEL_IF0		(0x0 << SPDIF_SCR_RXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_RXFIFO_FSEL_IF4		(0x1 << SPDIF_SCR_RXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_RXFIFO_FSEL_IF8		(0x2 << SPDIF_SCR_RXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_RXFIFO_FSEL_IF16		(0x3 << SPDIF_SCR_RXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_RXFIFO_AUTOSYNC_OFFSET	18
#define SPDIF_SCR_RXFIFO_AUTOSYNC_MASK		(1 << SPDIF_SCR_RXFIFO_AUTOSYNC_OFFSET)
#define SPDIF_SCR_RXFIFO_AUTOSYNC		(1 << SPDIF_SCR_RXFIFO_AUTOSYNC_OFFSET)
#define SPDIF_SCR_TXFIFO_AUTOSYNC_OFFSET	17
#define SPDIF_SCR_TXFIFO_AUTOSYNC_MASK		(1 << SPDIF_SCR_TXFIFO_AUTOSYNC_OFFSET)
#define SPDIF_SCR_TXFIFO_AUTOSYNC		(1 << SPDIF_SCR_TXFIFO_AUTOSYNC_OFFSET)
#define SPDIF_SCR_TXFIFO_FSEL_OFFSET		15
#define SPDIF_SCR_TXFIFO_FSEL_MASK		(0x3 << SPDIF_SCR_TXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_TXFIFO_FSEL_IF0		(0x0 << SPDIF_SCR_TXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_TXFIFO_FSEL_IF4		(0x1 << SPDIF_SCR_TXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_TXFIFO_FSEL_IF8		(0x2 << SPDIF_SCR_TXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_TXFIFO_FSEL_IF12		(0x3 << SPDIF_SCR_TXFIFO_FSEL_OFFSET)
#define SPDIF_SCR_LOW_POWER			(1 << 13)
#define SPDIF_SCR_SOFT_RESET			(1 << 12)
#define SPDIF_SCR_TXFIFO_CTRL_OFFSET		10
#define SPDIF_SCR_TXFIFO_CTRL_MASK		(0x3 << SPDIF_SCR_TXFIFO_CTRL_OFFSET)
#define SPDIF_SCR_TXFIFO_CTRL_ZERO		(0x0 << SPDIF_SCR_TXFIFO_CTRL_OFFSET)
#define SPDIF_SCR_TXFIFO_CTRL_NORMAL		(0x1 << SPDIF_SCR_TXFIFO_CTRL_OFFSET)
#define SPDIF_SCR_TXFIFO_CTRL_ONESAMPLE		(0x2 << SPDIF_SCR_TXFIFO_CTRL_OFFSET)
#define SPDIF_SCR_DMA_RX_EN_OFFSET		9
#define SPDIF_SCR_DMA_RX_EN_MASK		(1 << SPDIF_SCR_DMA_RX_EN_OFFSET)
#define SPDIF_SCR_DMA_RX_EN			(1 << SPDIF_SCR_DMA_RX_EN_OFFSET)
#define SPDIF_SCR_DMA_TX_EN_OFFSET		8
#define SPDIF_SCR_DMA_TX_EN_MASK		(1 << SPDIF_SCR_DMA_TX_EN_OFFSET)
#define SPDIF_SCR_DMA_TX_EN			(1 << SPDIF_SCR_DMA_TX_EN_OFFSET)
#define SPDIF_SCR_VAL_OFFSET			5
#define SPDIF_SCR_VAL_MASK			(1 << SPDIF_SCR_VAL_OFFSET)
#define SPDIF_SCR_VAL_CLEAR			(1 << SPDIF_SCR_VAL_OFFSET)
#define SPDIF_SCR_TXSEL_OFFSET			2
#define SPDIF_SCR_TXSEL_MASK			(0x7 << SPDIF_SCR_TXSEL_OFFSET)
#define SPDIF_SCR_TXSEL_OFF			(0 << SPDIF_SCR_TXSEL_OFFSET)
#define SPDIF_SCR_TXSEL_RX			(1 << SPDIF_SCR_TXSEL_OFFSET)
#define SPDIF_SCR_TXSEL_NORMAL			(0x5 << SPDIF_SCR_TXSEL_OFFSET)
#define SPDIF_SCR_USRC_SEL_OFFSET		0x0
#define SPDIF_SCR_USRC_SEL_MASK			(0x3 << SPDIF_SCR_USRC_SEL_OFFSET)
#define SPDIF_SCR_USRC_SEL_NONE			(0x0 << SPDIF_SCR_USRC_SEL_OFFSET)
#define SPDIF_SCR_USRC_SEL_RECV			(0x1 << SPDIF_SCR_USRC_SEL_OFFSET)
#define SPDIF_SCR_USRC_SEL_CHIP			(0x3 << SPDIF_SCR_USRC_SEL_OFFSET)

#define SPDIF_SRCD_USYNC_MODE_OFFSET		1
#define SPDIF_SRCD_USYNC_MODE_MASK		(1 << SPDIF_SRCD_USYNC_MODE_OFFSET)
#define SPDIF_SRCD_USYNC_MODE_CD_USER_CHAN	(1 << SPDIF_SRCD_USYNC_MODE_OFFSET)

#define SPDIF_SRPC_CLKSRC_SEL_OFFSET		7
#define SPDIF_SRPC_CLKSRC_SEL_MASK		(0xf << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_OSC		(0x0 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_TX		(0x1 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_ASRC	(0x2 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_EXT		(0x3 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_ESAI	(0x4 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_OSC		(0x5 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_TX		(0x6 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_ASRC		(0x7 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_EXT		(0x8 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_ESAI		(0x9 << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_MLB		(0xa << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_RX_OR_MLBPHY	(0xb << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_MLB		(0xc << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_CLKSRC_SEL_MLBPHY		(0xd << SPDIF_SRPC_CLKSRC_SEL_OFFSET)
#define SPDIF_SRPC_LOCK_OFFSET			6
#define SPDIF_SRPC_LOCK_MASK			(1 << SPDIF_SRPC_LOCK_OFFSET)
#define SPDIF_SRPC_LOCK				(1 << SPDIF_SRPC_LOCK_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_OFFSET		3
#define SPDIF_SRPC_GAIN_SEL_MASK		(0x3 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_24X			(0 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_16X			(1 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_12X			(2 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_8X			(3 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_6X			(4 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_4X			(5 << SPDIF_SRPC_GAIN_SEL_OFFSET)
#define SPDIF_SRPC_GAIN_SEL_3X			(6 << SPDIF_SRPC_GAIN_SEL_OFFSET)

#define SPDIF_STC_SYSCLK_DIV_OFFSET		11
#define SPDIF_STC_SYSCLK_DIV_MASK		(0x1ff << SPDIF_STC_SYSCLK_DIV_OFFSET)
#define SPDIF_STC_SYSCLK_NO_SIGNAL		((0 << SPDIF_STC_SYSCLK_DIV_OFFSET) & SPDIF_STC_SYSCLK_DIV_MASK)
#define SPDIF_STC_SYSCLK_DIV(x)			((((x) - 1) << SPDIF_STC_SYSCLK_DIV_OFFSET) & SPDIF_STC_SYSCLK_DIV_MASK)
#define SPDIF_STC_TXCLK_SRC_OFFSET		8
#define SPDIF_STC_TXCLK_SRC_MASK		(0x7 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_REF_CLK_32K		(0x0 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_TX_CLK		(0x1 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_ASRC_EXT_CLK	(0x2 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_SPDIF_EXT_CLK	(0x3 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_ESAI_HCKT		(0x4 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_IPG_CLK		(0x5 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_MLB			(0x6 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_SRC_MLB_PHY		(0x7 << SPDIF_STC_TXCLK_SRC_OFFSET)
#define SPDIF_STC_TXCLK_ALL_EN_OFFSET		7
#define SPDIF_STC_TXCLK_ALL_EN_MASK		(1 << SPDIF_STC_TXCLK_ALL_EN_OFFSET)
#define SPDIF_STC_TXCLK_ALL_EN			(1 << SPDIF_STC_TXCLK_ALL_EN_OFFSET)
#define SPDIF_STC_TXCLK_DIV_OFFSET		0
#define SPDIF_STC_TXCLK_DIV_MASK		(0x7ff << SPDIF_STC_TXCLK_DIV_OFFSET)
#define SPDIF_STC_TXCLK_DIV(x)			((((x) - 1) << SPDIF_STC_TXCLK_DIV_OFFSET) & SPDIF_STC_TXCLK_DIV_MASK)
#define SPDIF_STC_TXCLK_SRC_MAX			8

#define SPDIF_SIESC_LOCK			(1 << 20)
#define SPDIF_SIESC_TX_UN_OV			(1 << 19)
#define SPDIF_SIESC_TX_RESYN			(1 << 18)
#define SPDIF_SIESC_CNEW			(1 << 17)
#define SPDIF_SIESC_VAL_NO_GOOD			(1 << 16)
#define SPDIF_SIESC_SYM_ERR			(1 << 15)
#define SPDIF_SIESC_BIT_ERR			(1 << 14)
#define SPDIF_SIESC_U_RX_FUL			(1 << 10)
#define SPDIF_SIESC_U_RX_OV			(1 << 9)
#define SPDIF_SIESC_Q_RX_FUL			(1 << 8)
#define SPDIF_SIESC_Q_RX_OV			(1 << 7)
#define SPDIF_SIESC_U_Q_SYNC			(1 << 6)
#define SPDIF_SIESC_U_Q_ERR			(1 << 5)
#define SPDIF_SIESC_RX_FIFO_UN_OV		(1 << 4)
#define SPDIF_SIESC_RX_FIFO_RESYN		(1 << 3)
#define SPDIF_SIESC_LOCK_LOSS			(1 << 2)
#define SPDIF_SIESC_TX_EM			(1 << 1)
#define SPDIF_SIESC_RX_FIFO_FUL			(1 << 0)
#define SPDIF_SIESC_MASK			0x1FC7FF

extern int imx_spdif_init(void);
extern void imx_spdif_exit(void);

#endif
