/*
 * Copyright (c) 2015-2017, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * Copyright (C) 2010 Sascha Hauer <s.hauer@pengutronix.de>
 *
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef EPIT_H
#define EPIT_H

#define EPIT_CR		0x00
#define EPIT_SR		0x04
#define EPIT_LR		0x08
#define EPIT_CMPR	0x0c
#define EPIT_CNR	0x10

#define EPIT_CR_EN			(1 << 0)
#define EPIT_CR_ENMOD			(1 << 1)
#define EPIT_CR_OCIEN			(1 << 2)
#define EPIT_CR_RLD			(1 << 3)
#define EPIT_CR_PRESC(x)		(((x) & 0xfff) << 4)
#define EPIT_CR_SWR			(1 << 16)
#define EPIT_CR_IOVW			(1 << 17)
#define EPIT_CR_DBGEN			(1 << 18)
#define EPIT_CR_WAITEN			(1 << 19)
#define EPIT_CR_RES			(1 << 20)
#define EPIT_CR_STOPEN			(1 << 21)
#define EPIT_CR_OM_DISCON		(0 << 22)
#define EPIT_CR_OM_TOGGLE		(1 << 22)
#define EPIT_CR_OM_CLEAR		(2 << 22)
#define EPIT_CR_OM_SET			(3 << 22)
#define EPIT_CR_CLKSRC_OFF		(0 << 24)
#define EPIT_CR_CLKSRC_PERIPHERAL	(1 << 24)
#define EPIT_CR_CLKSRC_REF_HIGH		(2 << 24)
#define EPIT_CR_CLKSRC_REF_LOW		(3 << 24)
#define EPIT_CR_CLKSRC_MASK		(3 << 24)

#define EPIT_SR_OCIF			(1 << 0)

extern int epit_init(void);
extern void epit_exit(void);

#endif
