/*
 * Copyright (c) 2014-2017, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef AUDMUX_H
#define AUDMUX_H

#define IMX_AUDMUX_PTCR_TFSDIR		(1 << 31)
#define IMX_AUDMUX_PTCR_TFSEL(x)	(((x) & 0xf) << 27)
#define IMX_AUDMUX_PTCR_TCLKDIR		(1 << 26)
#define IMX_AUDMUX_PTCR_TCSEL(x)	(((x) & 0xf) << 22)
#define IMX_AUDMUX_PTCR_RFSDIR		(1 << 21)
#define IMX_AUDMUX_PTCR_RFSEL(x)	(((x) & 0xf) << 17)
#define IMX_AUDMUX_PTCR_RCLKDIR		(1 << 16)
#define IMX_AUDMUX_PTCR_RCSEL(x)	(((x) & 0xf) << 12)
#define IMX_AUDMUX_PTCR_SYN		(1 << 11)

#define IMX_AUDMUX_PDCR_RXDSEL(x)	(((x) & 0x7) << 13)
#define IMX_AUDMUX_PDCR_TXRXEN		(1 << 12)
#define IMX_AUDMUX_PDCR_MODE		(1 << 8)
#define IMX_AUDMUX_PDCR_INMMASK(x)	((x) & 0xff)

#define IMX_AUDMUX_PORTS			7

extern int audmux_init(void);
extern void audmux_exit(void);

#endif
