/* Copyright (c) 2019-2021, Sonos, Inc.  All rights reserved. */

#ifndef HWEVTQ_USER_API_H
#define HWEVTQ_USER_API_H

#ifdef __KERNEL__
#include <linux/time.h>
#include <linux/types.h>
#else
#include <sys/time.h>
#include <sys/types.h>
#endif

#if defined(__SONOS_MIPS__) || defined(__SONOS_FILLMORE__)
#define BUTTON_DEVICE      "/dev/buttons"
#else
#if defined(SONOS_ARCH_ATTR_SUPPORTS_SYSSW_HAL) && !defined(SONOS_ARCH_ATTR_SUPPORTS_AUDIODEV)
#define BUTTON_DEVICE      "/dev/event_queue"
#else
#define BUTTON_DEVICE      "/dev/audioctl"
#endif
#endif

#define HWEVTQ_FAMILY_NAME "HW_EVQ"
enum HWEVTQ_EventInfo {
    HWEVTQINFO_NO_EVENT,
    HWEVTQINFO_PRESSED,
    HWEVTQINFO_RELEASED,
    HWEVTQINFO_REPEATED,
    HWEVTQINFO_CONNECTED,
    HWEVTQINFO_DISCONNECTED,
    HWEVTQINFO_SWIPED,
    HWEVTQINFO_ORIENT_HORIZONTAL,
    HWEVTQINFO_ORIENT_TABLE,
    HWEVTQINFO_ORIENT_VERTICAL,
    HWEVTQINFO_ORIENT_VERTICAL_LEFT,
    HWEVTQINFO_ORIENT_VERTICAL_RIGHT,
    HWEVTQINFO_ORIENT_WALL_ABOVE,
    HWEVTQINFO_ORIENT_WALL_BELOW,
    HWEVTQINFO_ORIENT_HORIZONTAL_WALL,
    HWEVTQINFO_ORIENT_VERTICAL_WALL,
    HWEVTQINFO_ORIENT_VERTICAL_LEFT_WALL,
    HWEVTQINFO_ORIENT_VERTICAL_RIGHT_WALL,
    HWEVTQINFO_QUEUE_OVERRUN,
    HWEVTQINFO_TIMEOUT,
    HWEVTQINFO_CLIP,
    HWEVTQINFO_HW_ERROR,
    HWEVTQINFO_HW_OK,
    HWEVTQINFO_TEMP_WARNING,
    HWEVTQINFO_TEMP_FAULT,
    HWEVTQINFO_TEMP_OK,
    HWEVTQINFO_AMP_HI_RAIL,
    HWEVTQINFO_AMP_LO_RAIL,
    HWEVTQINFO_AMP_OFF,
    HWEVTQINFO_UPDATE,
    HWEVTQINFO_MOTION_DETECTED,
    HWEVTQINFO_MOTION_SETTLED,
    HWEVTQINFO_HW_FAULT,
    HWEVTQINFO_WAKEUP,
    HWEVTQINFO_ON_BATTERY,
    HWEVTQINFO_ON_CHARGER,
    HWEVTQINFO_LOW_BATTERY,
    HWEVTQINFO_CRIT_BATTERY,
    HWEVTQINFO_ALARM,
    HWEVTQINFO_INVALID_USB_CHARGER,
    HWEVTQINFO_NUM_EVENTS
};


enum HWEVTQ_EventSource {
    HWEVTQSOURCE_NO_SOURCE,
    HWEVTQSOURCE_AMP,
    HWEVTQSOURCE_LEDS,
    HWEVTQSOURCE_IR,
    HWEVTQSOURCE_HEADPHONE,
    HWEVTQSOURCE_SUBWOOFER,
    HWEVTQSOURCE_ORIENTATION,
    HWEVTQSOURCE_BUTTON_PLAYPAUSE,
    HWEVTQSOURCE_BUTTON_VOL_UP,
    HWEVTQSOURCE_BUTTON_VOL_DN,
    HWEVTQSOURCE_BUTTON_JOIN,
    HWEVTQSOURCE_BUTTON_MODE,
    HWEVTQSOURCE_BUTTON_POWER,
    HWEVTQSOURCE_BUTTON_MICMUTE,
    HWEVTQSOURCE_CAPZONEA,
    HWEVTQSOURCE_CAPZONEB,
    HWEVTQSOURCE_CAPZONEC,
    HWEVTQSOURCE_CAPZONEM,
    HWEVTQSOURCE_CAPZONECAT,
    HWEVTQSOURCE_LINEIN,
    HWEVTQSOURCE_DAC,
    HWEVTQSOURCE_ADC,
    HWEVTQSOURCE_CPU,
    HWEVTQSOURCE_SOC,
    HWEVTQSOURCE_SONGLE,
    HWEVTQSOURCE_POWER,
    HWEVTQSOURCE_AVTRIGGER,
    HWEVTQSOURCE_LIGHT_SENSOR,
    HWEVTQSOURCE_LINEOUT,
    HWEVTQSOURCE_SPDIF_OUT,
    HWEVTQSOURCE_HDMI,
    HWEVTQSOURCE_NFC,
    HWEVTQSOURCE_MOTION_DETECTOR,
    HWEVTQSOURCE_BLE,
    HWEVTQSOURCE_WIFI,
    HWEVTQSOURCE_BATTERY,
    HWEVTQSOURCE_CHARGER,
    HWEVTQSOURCE_RTC,
    HWEVTQSOURCE_FUEL_GAUGE,
    HWEVTQSOURCE_NUM_SOURCES
};

struct button_evt {
    enum HWEVTQ_EventSource m_lSource;
    enum HWEVTQ_EventInfo m_lInfo;
    struct timeval m_timestamp;
};

typedef struct button_evt button_evt;

#define IS_VALID_HWEVENT(source, info)  ((source < HWEVTQSOURCE_NUM_SOURCES) &&    \
                                         (source >= HWEVTQSOURCE_NO_SOURCE) &&     \
                                         (info < HWEVTQINFO_NUM_EVENTS) &&         \
                                         (info >= HWEVTQINFO_NO_EVENT))

#define IS_VALID_EVENT(evt)     (((evt)->m_lSource < HWEVTQSOURCE_NUM_SOURCES) &&    \
                                 ((evt)->m_lSource >= HWEVTQSOURCE_NO_SOURCE) &&     \
                                 ((evt)->m_lInfo < HWEVTQINFO_NUM_EVENTS) &&         \
                                 ((evt)->m_lInfo >= HWEVTQINFO_NO_EVENT))
#endif
