/* Copyright (c) 2019-2020, Sonos, Inc.  All rights reserved. */

#ifndef HWEVTQ_MSG_API_H
#define HWEVTQ_MSG_API_H

#ifdef __KERNEL__
#include <net/netlink.h>
#else
#include <netlink/attr.h>
#include <netlink/netlink.h>
#include <netlink/genl/genl.h>
#include <netlink/genl/family.h>
#include <netlink/genl/ctrl.h>
#endif

#define HWEVTQ_MCAST_GRP_RES_NAME "reserved"
#define HWEVTQ_MCAST_GRP_AUDIO_NAME "hwevtq_audio"
#define HWEVTQ_MCAST_GRP_BATTERY_NAME "hwevtq_battery"
#define HWEVTQ_MCAST_GRP_BUTTON_NAME "hwevtq_button"
#define HWEVTQ_MCAST_GRP_BUTTON_POWER_NAME "hwevtq_btnpwr"
#define HWEVTQ_MCAST_GRP_CAPZONE_NAME "hwevtq_capzone"
#define HWEVTQ_MCAST_GRP_HT_NAME "hwevtq_ht"
#define HWEVTQ_MCAST_GRP_LED_NAME "hwevtq_led"
#define HWEVTQ_MCAST_GRP_SENSOR_NAME "hwevtq_sensor"
#define HWEVTQ_MCAST_GRP_TEMP_NAME "hwevtq_temp"
#define HWEVTQ_MCAST_GRP_WAKEUP_NAME "hwevtq_wakeup"
#define HWEVTQ_MCAST_GRP_MAX    11

#define HWEVTQ_TEST_MSG_MAX_SIZE	256

#define HWEVTQ_HELLO_INTERVAL		60000

enum {
        HWEVTQ_CMD_UNSPECIFIED,
        HWEVTQ_CMD_EVENT,
        HWEVTQ_CMD_MAX
};

enum hwevtq_multicast_groups {
	HWEVTQ_MCAST_GRP_RES,
	HWEVTQ_MCAST_GRP_AUDIO,
	HWEVTQ_MCAST_GRP_BATTERY,
	HWEVTQ_MCAST_GRP_BUTTON,
	HWEVTQ_MCAST_GRP_BUTTON_POWER,
	HWEVTQ_MCAST_GRP_CAPZONE,
	HWEVTQ_MCAST_GRP_HT,
	HWEVTQ_MCAST_GRP_LED,
	HWEVTQ_MCAST_GRP_SENSOR,
	HWEVTQ_MCAST_GRP_TEMP,
	HWEVTQ_MCAST_GRP_WAKEUP,
};

const char *hwevtq_mcgrp_names[HWEVTQ_MCAST_GRP_MAX] = {
	HWEVTQ_MCAST_GRP_RES_NAME,
	HWEVTQ_MCAST_GRP_AUDIO_NAME,
	HWEVTQ_MCAST_GRP_BATTERY_NAME,
	HWEVTQ_MCAST_GRP_BUTTON_NAME,
	HWEVTQ_MCAST_GRP_BUTTON_POWER_NAME,
	HWEVTQ_MCAST_GRP_CAPZONE_NAME,
	HWEVTQ_MCAST_GRP_HT_NAME,
	HWEVTQ_MCAST_GRP_LED_NAME,
	HWEVTQ_MCAST_GRP_SENSOR_NAME,
	HWEVTQ_MCAST_GRP_TEMP_NAME,
	HWEVTQ_MCAST_GRP_WAKEUP_NAME,
};

enum {
        HWEVTQ_ATTR_UNSPEC,
        HWEVTQ_ATTR_MSG,
        HWEVTQ_ATTR_TIMESTAMP_SECS,
        HWEVTQ_ATTR_TIMESTAMP_USECS,
        HWEVTQ_ATTR_EVTSRC,
        HWEVTQ_ATTR_EVTINFO,
        HWEVTQ_ATTR_PRIVATE,
        __HWEVTQ_MAX_ATTR,
};
#define HWEVTQ_MAX_ATTR (__HWEVTQ_MAX_ATTR -1)

static struct nla_policy hwevtq_policy[HWEVTQ_MAX_ATTR + 1] = {
	 [HWEVTQ_ATTR_MSG] = {.type = NLA_STRING,
#ifdef __KERNEL__
                                .len = HWEVTQ_TEST_MSG_MAX_SIZE},
#else
                                .maxlen = HWEVTQ_TEST_MSG_MAX_SIZE},
#endif
        [HWEVTQ_ATTR_TIMESTAMP_SECS] = {.type = NLA_U64,
#ifdef __KERNEL__
				.len = sizeof(__u64)},
#else
				.maxlen = sizeof(__u64)},
#endif
        [HWEVTQ_ATTR_TIMESTAMP_USECS] = {.type = NLA_U64,
#ifdef __KERNEL__
	.len = sizeof(__u64)},
#else
				.maxlen = sizeof(__u64)},
#endif
        [HWEVTQ_ATTR_EVTSRC] = {.type = NLA_U16,
#ifdef __KERNEL__
				.len = sizeof(__u16)},
#else
				.maxlen = sizeof(__u16)},
#endif
        [HWEVTQ_ATTR_EVTINFO] = {.type = NLA_U16,
#ifdef __KERNEL__
				.len = sizeof(__u16)},
#else
				.maxlen = sizeof(__u16)},
#endif
        [HWEVTQ_ATTR_PRIVATE] = {.type = NLA_U32,
#ifdef __KERNEL__
				.len = sizeof(__u32)},
#else
				.maxlen = sizeof(__u32)},
#endif
};
#endif
