/* Copyright (c) 2019-2020, Sonos, Inc.  All rights reserved. */

#ifndef HWEVTQ_API_H
#define HWEVTQ_API_H

#include "hwevent_queue_user_api.h"

#define HWEVTQ_REG_NAME_LEN	64

extern int hwevtq_send_event(enum HWEVTQ_EventSource source, enum HWEVTQ_EventInfo info);

extern int hwevtq_send_event_defer(enum HWEVTQ_EventSource source, enum HWEVTQ_EventInfo info);

typedef void (*hwevtq_cb)(void *param, enum HWEVTQ_EventSource, enum HWEVTQ_EventInfo);

struct hwevtq_reg {
        struct list_head list;
        void *param;
        hwevtq_cb cbfunc;
	enum HWEVTQ_EventSource source;
        enum HWEVTQ_EventInfo info;
        char name[HWEVTQ_REG_NAME_LEN];
        int  magic;
        u32  calls;
};


extern struct hwevtq_reg * hwevtq_register_all(hwevtq_cb cb, void *param, char *name);

extern int hwevtq_unregister_event(struct hwevtq_reg **);

extern struct hwevtq_reg * hwevtq_register_event(enum HWEVTQ_EventSource source,
			enum HWEVTQ_EventInfo info, hwevtq_cb cb, void *param, char *name);

extern struct hwevtq_reg * hwevtq_register_info(enum HWEVTQ_EventInfo info,
				hwevtq_cb cb, void *param, char *name);

extern struct hwevtq_reg * hwevtq_register_source(enum HWEVTQ_EventSource source,
				hwevtq_cb cb, void *param, char *name);

enum HWEVTQ_EventInfo hwevtq_queue_get_event(enum HWEVTQ_EventSource source);

extern char *hwevtq_get_source_string(enum HWEVTQ_EventSource src);
extern char *hwevtq_get_event_string(enum HWEVTQ_EventInfo info);
#endif
