/*
 * Copyright (c) 2018-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * SONOS LED control module header
 */

#ifndef HDMICTL_H
#define HDMICTL_H

#include <linux/types.h>

#define HDMICTL_DEVICE_NAME	"hdmictl"
#define HDMICTL_DEVICE_NODE	"/dev/"HDMICTL_DEVICE_NAME
#define HDMICTL_MAJOR_NUMBER	(217)

#define HDMICTL_VERSION		(3)

#define HDMICTL_GET_VERSION	_IOR(HDMICTL_MAJOR_NUMBER, 0, __u32)
#define HDMICTL_GET_5V_STATE	_IOR(HDMICTL_MAJOR_NUMBER, 1, __u8)
#define HDMICTL_SET_5V_STATE	_IOW(HDMICTL_MAJOR_NUMBER, 2, __u8)
#define HDMICTL_GET_FAULT_STATE	_IOW(HDMICTL_MAJOR_NUMBER, 3, __u8)

#ifdef __KERNEL__
extern void hdmictl_set_virtual_hpd(bool vhpd);
#endif

#endif
