/*
 * Copyright (c) 2016-2020 Sonos Inc.
 * All rights reserved.
 */

#ifndef EVENT_QUEUE_API_H
#define EVENT_QUEUE_API_H

#include <linux/list.h>
#include <linux/semaphore.h>
#include "button_event.h"
#include "hwevent_queue_user_api.h"

#define EVENT_REG_NAME_LEN   64

typedef void (*event_cbfunc)(void *param, enum HWEVTQ_EventSource, enum HWEVTQ_EventInfo);

struct event_reg {
	struct list_head list;
	void *param;
	event_cbfunc cbfunc;
	struct button_event_queue *beq;
	enum HWEVTQ_EventSource source;
	enum HWEVTQ_EventInfo info;
	char name[EVENT_REG_NAME_LEN];
	int  magic;
	u32  calls;
};


extern struct event_reg * event_register_all(event_cbfunc cb, void *param, char *name);

extern int event_unregister_event(struct event_reg **);

extern struct event_reg * event_register_event(enum HWEVTQ_EventSource source, enum HWEVTQ_EventInfo info, event_cbfunc cb, void *param, char *name);

extern struct event_reg * event_register_info(enum HWEVTQ_EventInfo info, event_cbfunc cb, void *param, char *name);

extern struct event_reg * event_register_source(enum HWEVTQ_EventSource source, event_cbfunc cb, void *param, char *name);

int event_queue_send_event(enum HWEVTQ_EventSource source, enum HWEVTQ_EventInfo info);

extern int event_queue_send_event_defer(enum HWEVTQ_EventSource source, enum HWEVTQ_EventInfo info);

enum HWEVTQ_EventInfo event_queue_get_event(enum HWEVTQ_EventSource source);

extern char * event_queue_get_source_string(enum HWEVTQ_EventSource source);
extern char * event_queue_get_event_string(enum HWEVTQ_EventInfo event);

unsigned int event_queue_circular_buffer_size(void);

#endif
