/*
 * Copyright (c) 2016 - 2020 Sonos Inc.
 * All rights reserved.
 */


#ifndef BUTTON_INST_H
#define BUTTON_INST_H

#include "hwevent_queue_user_api.h"

enum button_pins {
	BUTTONS_INDEX_BUTTON_PLAYPAUSE,
	BUTTONS_INDEX_BUTTON_VOL_UP,
	BUTTONS_INDEX_BUTTON_VOL_DN,
	BUTTONS_INDEX_BUTTON_JOIN,
	BUTTONS_INDEX_BUTTON_MODE,
	BUTTONS_INDEX_BUTTON_POWER,
	BUTTONS_INDEX_BUTTON_MICMUTE,
	BUTTONS_NUM_SUPPORTED
};

struct button_inst {
	char *name;
	int gpio;
	enum HWEVTQ_EventSource source;
	enum HWEVTQ_EventInfo (*button_read)(enum button_pins pin);
};

#define BUTTON_MAX_SIM_CMD_NAME 20
struct button_sim_inst {
	char cmd[BUTTON_MAX_SIM_CMD_NAME];
	int no_repeat_sim;
	enum HWEVTQ_EventSource source;
};

extern struct button_inst buttons_table[];

static inline int buttons_get_gpio(enum button_pins index)
{
	return buttons_table[index].gpio;
}

static inline int buttons_get_source(enum button_pins index)
{
	return buttons_table[index].source;
}

static inline const char * buttons_get_label(enum button_pins index)
{
	return buttons_table[index].name;
}
#endif
