/*
 * Copyright (c) 2016-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * BLACKBOX: Kernel trace functionality for Sonos kernel modules
 */
#ifndef BLACKBOX_H
#define BLACKBOX_H

#include <linux/device.h>

#define BB_LVL_ERR	(0x80000000)
#define BB_LVL_WARNING	(0x40000000)
#define BB_LVL_INFO	(0x20000000)
#define BB_LVL_DEBUG	(0x10000000)
#define BB_LVL_ALL	(0xf0000000)

#define BB_MOD_BLACKBOX	(0x00000001)
#define BB_MOD_LLA	(0x00000002)
#define BB_MOD_LEDCTL	(0x00000004)
#define BB_MOD_AMPCTL	(0x00000008)
#define BB_MOD_EVENT	(0x00000010)
#define BB_MOD_SENSORS	(0x00000020)
#define BB_MOD_SDD	(0x00000040)
#define BB_MOD_CHK	(0x00000080)
#define BB_MOD_APPLE	(0x00000100)
#define BB_MOD_VBLOCK	(0x00000200)
#define BB_MOD_CAAM	(0x00000400)
#define BB_MOD_PSMON	(0x00000800)
#define BB_MOD_M4	(0x00001000)
#define BB_MOD_MICCTL	(0x00002000)
#define BB_MOD_SWD	(0x00004000)
#define BB_MOD_FPGA	(0x00008000)
#define BB_MOD_EEPROM	(0x00010000)
#define BB_MOD_IR       (0x00020000)
#define BB_MOD_CCGSWD   (0x00040000)
#define BB_MOD_MCU      (0x00080000)
#define BB_MOD_HDMICTL  (0x00100000)
#define BB_MOD_QCADDFA  (0x00200000)
#define BB_MOD_USBPD    (0x00400000)
#define BB_MOD_PROCFS	(0x00800000)
#define BB_MOD_BLUTOOTH (0x01000000)
#define BB_MOD_USR2	(0x02000000)
#define BB_MOD_USR3	(0x04000000)
#define BB_MOD_USR4	(0x08000000)
#define BB_MOD_ALL	(0x0fffffff)

#define BB_MASK_MOD(x)	(x & 0x0fffffff)
#define BB_MASK_LVL(x)	(x & 0xf0000000)

#define BB_MASK_DEFAULT		(BB_MOD_ALL | BB_LVL_ERR | BB_LVL_WARNING | BB_LVL_INFO)
#define BB_PRINTK_DEFAULT	(BB_MOD_ALL | BB_LVL_ERR | BB_LVL_WARNING)

#define BB_ENTRY_MAX	(256)

#define BB_CONT_NONE	(0x0000)
#define BB_CONT_HIRQ	(0x0001)
#define BB_CONT_SIRQ	(0x0002)

extern void bb_log_dev(struct device *dev, unsigned mod, unsigned lvl, const char *fmt, ...)
	__attribute__ ((format (printf, 4, 5)));

#define bb_log(mod, lvl, fmt, args...) \
	bb_log_dev(NULL, mod, lvl, fmt, ##args)

#ifdef BB_MOD_DEBUG
#define bb_log_dbg(mod, fmt, args...) \
	bb_log_dev(NULL, mod, BB_LVL_DEBUG, "%s@%d: "fmt, __FUNCTION__, __LINE__, ##args)
#define bb_log_dbg_dev(dev, mod, fmt, args...) \
	bb_log_dev(dev, mod, BB_LVL_DEBUG, "%s@%d: "fmt, __FUNCTION__, __LINE__, ##args)
#else
#define bb_log_dbg(mod, fmt, args...)
#define bb_log_dbg_dev(dev, mod, fmt, args...)
#endif

#endif
