/*
 * Copyright (c) 2014-2017, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 */

#ifndef AK4458_H
#define AK4458_H

#define AK4458_NUM_REGS			0x15

#define AK4458_REG_CTL_1		0x00
#define AK4458_REG_CTL_2		0x01
#define AK4458_REG_CTL_3		0x02
#define AK4458_REG_L1_ATT		0x03
#define AK4458_REG_R1_ATT		0x04
#define AK4458_REG_CTL_4		0x05
#define AK4458_REG_DSD_1		0x06
#define AK4458_REG_CTL_5		0x07
#define AK4458_REG_SOUND_CTL		0x08
#define AK4458_REG_DSD_2		0x09
#define AK4458_REG_CTL_6		0x0a
#define AK4458_REG_CTL_7		0x0b
#define AK4458_REG_CTL_8		0x0c
#define AK4458_REG_CTL_9		0x0d
#define AK4458_REG_CTL_10		0x0e
#define AK4458_REG_L2_ATT		0x0f
#define AK4458_REG_R2_ATT		0x10
#define AK4458_REG_L3_ATT		0x11
#define AK4458_REG_R3_ATT		0x12
#define AK4458_REG_L4_ATT		0x13
#define AK4458_REG_R4_ATT		0x14

#define AK4458_CTL_1_RSTN		0x01
#define AK4458_CTL_1_DIF_MODE(x)	((x & 0x07) << 1)
#define AK4458_CTL_1_ACKS		0x80
#define AK4458_CTL_2_SMUTE		0x01
#define AK4458_CTL_2_DEM1_MODE(x)	((x & 0x03) << 1)
#define AK4458_CTL_2_DFS_MODE(x)	((x & 0x03) << 3)
#define AK4458_CTL_2_SD			0x20
#define AK4458_CTL_6_DEM2_MODE(x)	(x & 0x03)
#define AK4458_CTL_6_DAC1_PWR		0x04
#define AK4458_CTL_6_DAC2_PWR		0x08
#define AK4458_CTL_6_SDS_MODE(x)	((x & 0x03) << 4)
#define AK4458_CTL_6_TDM_MODE(x)	((x & 0x03) << 6)
#define AK4458_CTL_7_DCHAIN		0x02
#define AK4458_CTL_7_DAC3_PWR		0x04
#define AK4458_CTL_7_DAC4_PWR		0x08
#define AK4458_CTL_7_SDS		0x10
#define AK4458_CTL_7_ATS_MODE(x)	((x & 0x03) << 6)

extern int ak4458_i2c_init(void);
extern void ak4458_i2c_exit(void);
extern int ak4458_dac_smute_i2c(int on);
extern int ak4458_dac_reset_i2c(int on);

#endif
