/*
 * Copyright (c) 2014-2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef _ADP8863_H_
#define _ADP8863_H_

#include "sonos_led.h"
#include "ledctl.h"


#define ADP8863_I2C_ADDR		0x2b

#define ADP8863_REG_MFDVID		0x00
#define ADP8863_MFDVID_MANID_MASK	0xf0
#define ADP8863_MFDVID_DEVID_MASK	0x0f
#define ADP8863_ID			0x2a

#define ADP8863_REG_MDCR		0x01
#define ADP8863_MDCR_INT_CFG		0x40
#define ADP8863_MDCR_NSTBY		0x20
#define ADP8863_MDCR_ALT_GSEL		0x10
#define ADP8863_MDCR_GDWN_DIS		0x08
#define ADP8863_MDCR_SIS_EN		0x04
#define ADP8863_MDCR_BL_EN		0x01

#define ADP8863_REG_MDCR2		0x02
#define ADP8863_MDCR2_SHORT_INT		0x10
#define ADP8863_MDCR2_TSD_INT		0x08
#define ADP8863_MDCR2_OVP_INT		0x04
#define ADP8863_MDCR2_CMP2_INT		0x02
#define ADP8863_MDCR2_CMP_INT		0x01

#define ADP8863_REG_INTR_EN		0x03
#define ADP8863_INTR_EN_SHORT_IEN	0x10
#define ADP8863_INTR_EN_TSD_IEN		0x08
#define ADP8863_INTR_EN_OVP_IEN		0x04
#define ADP8863_INTR_EN_CMP2_IEN	0x02
#define ADP8863_INTR_EN_CMP_IEN		0x01

#define ADP8863_REG_CFGR		0x04
#define ADP8863_CFGR_SEL_AB		0x20
#define ADP8863_CFGR_CMP2_SEL		0x10
#define ADP8863_CFGR_BLV(x)		((x & 0x3) << 3)
#define ADP8863_CFGR_LAW(x)		((x & 0x3) << 1)
#define ADP8863_CFGR_FOVR		0x01

#define ADP8863_REG_BLSEN		0x05
#define ADP8863_BLSEN_EN(x)		(x & 0x7f)
#define ADP8863_BLSEN_D7EN		0x40
#define ADP8863_BLSEN_D6EN		0x20
#define ADP8863_BLSEN_D5EN		0x10
#define ADP8863_BLSEN_D4EN		0x08
#define ADP8863_BLSEN_D3EN		0x04
#define ADP8863_BLSEN_D2EN		0x02
#define ADP8863_BLSEN_D1EN		0x01

#define ADP8863_REG_BLOFF		0x06
#define ADP8863_BLOFF_OFFT(x)		(x & 0x7f)

#define ADP8863_REG_BLDIM		0x07
#define ADP8863_BLDIM_DIMT(x)		(x & 0x7f)

#define ADP8863_REG_BLFR		0x08
#define ADP8863_BLFR_BL_FO(x)		((x & 0xf) << 4)
#define ADP8863_BLFR_BL_FI(x)		(x & 0xf)

#define ADP8863_REG_BLMX1		0x09
#define ADP8863_BLMX1_BL1_MC(x)		(x & 0x7f)

#define ADP8863_REG_BLDM1		0x0a
#define ADP8863_BLDM1_BL1_DC(x)		(x & 0x7f)

#define ADP8863_REG_BLMX2		0x0b
#define ADP8863_BLMX2_BL2_MC(x)		(x & 0x7f)

#define ADP8863_REG_BLDM2		0x0c
#define ADP8863_BLDM2_BL2_DC(x)		(x & 0x7f)

#define ADP8863_REG_BLMX3		0x0d
#define ADP8863_BLMX3_BL3_MC(x)		(x & 0x7f)

#define ADP8863_REG_BLDM3		0x0e
#define ADP8863_BLDM3_BL3_DC(x)		(x & 0x7f)


#define ADP8863_REG_ISCFR		0x0f
#define ADP8863_ISCFR_LAW(x)		(x & 0x3)

#define ADP8863_REG_ISCC		0x10
#define ADP8863_ISCC_EN(x)		((1 << (x-1)) & 0x7f)
#define ADP8863_ISCC_SC7_EN		0x40
#define ADP8863_ISCC_SC6_EN		0x20
#define ADP8863_ISCC_SC5_EN		0x10
#define ADP8863_ISCC_SC4_EN		0x08
#define ADP8863_ISCC_SC3_EN		0x04
#define ADP8863_ISCC_SC2_EN		0x02
#define ADP8863_ISCC_SC1_EN		0x01

#define ADP8863_REG_ISCT1		0x11
#define ADP8863_ISCT1_SCON(x)		((x & 0x3) << 6)
#define ADP8863_ISCT1_SC7OFF(x)		((x & 0x3) << 4)
#define ADP8863_ISCT1_SC6OFF(x)		((x & 0x3) << 2)
#define ADP8863_ISCT1_SC5OFF(x)		(x & 0x3)

#define ADP8863_REG_ISCT2		0x12
#define ADP8863_ISCT2_SC4OFF(x)		((x & 0x3) << 6)
#define ADP8863_ISCT2_SC3OFF(x)		((x & 0x3) << 4)
#define ADP8863_ISCT2_SC2OFF(x)		((x & 0x3) << 2)
#define ADP8863_ISCT2_SC1OFF(x)		(x & 0x3)

#define ADP8863_REG_ISCF		0x13
#define ADP8863_ISCF_SCFO(x)		((x & 0xf) << 4)
#define ADP8863_ISCF_SCFI(x)		(x & 0xf)

#define ADP8863_ISC7_SCR		0x80
#define ADP8863_REG_ISC7		0x14
#define ADP8863_REG_ISC6		0x15
#define ADP8863_REG_ISC5		0x16
#define ADP8863_REG_ISC4		0x17
#define ADP8863_REG_ISC3		0x18
#define ADP8863_REG_ISC2		0x19
#define ADP8863_REG_ISC1		0x1a
#define ADP8863_REG_ISC(N)		(0x1b - N)
#define ADP8863_ISC_SCD(x)		(x & 0x7f)

#define ADP8863_REG_CCFG		0x1b
#define ADP8863_REG_CCFG2		0x1c
#define ADP8863_REG_L2_TRP		0x1d
#define ADP8863_REG_L2_HYS		0x1e
#define ADP8863_REG_L3_TRP		0x1f
#define ADP8863_REG_L3_HYS		0x20
#define ADP8863_REG_PH1LEVL		0x21
#define ADP8863_REG_PH1LEVH		0x22
#define ADP8863_REG_PH2LEVL		0x23
#define ADP8863_REG_PH2LEVH		0x24

#define ADP8863_MAX_REG			0x25

#define ADP8863_MAX_FADE_TIME		5500
#define ADP8863_MIN_FADE_TIME		300

struct adp8863_reg_setting {
	const char *name;
	uint8_t value;
};

#define ADP8863_LED_MASK(led) (1 << (led-1))

extern int adp8863_status(void);

extern int adp8863_led_fault(void);

extern int adp8863_set_isc_fade_times(uint32_t fade_time);
extern int adp8863_set_brightness(int leds, int brightness);

#endif
