/*
 * Copyright (c) 2019-2020, Sonos, Inc.  All rights reserved.
 *
 * SPDX-License-Identifier: GPL-2.0
 */

#ifndef HWEVTQ_PRIVATE_H
#define HWEVTQ_PRIVATE_H

#include <linux/cdev.h>
#include "hwevent_queue_user_api.h"

#define HWEVTQ_DEVICE_NAME	"hwevtq"
#define HWEVTQ_DEVICE_NODE	"/dev/"HWEVTQ_DEVICE_NAME

#define HWEVTQ_DEVICE_MAJOR	(237)

struct hwevtq_defer_event {
        struct work_struct worker;
        enum HWEVTQ_EventSource source;
        enum HWEVTQ_EventInfo info;
};

#define HWEVTQ_NUM_DEFERRED_EVENTS 32

#define HWEVTQ_TEST_HELLO_INTERVAL	60000

extern int hwevtq_rx_msg(struct sk_buff *skb, struct genl_info *info);

typedef struct hwevtctl {
	struct device	*dev;
	dev_t		devno;
	struct cdev	c_dev;
} hwevtctl_t;

#if LINUX_VERSION_CODE > KERNEL_VERSION(4,4,0)
static const struct genl_ops hwevtq_ops[] = {
	{
                .cmd = HWEVTQ_CMD_EVENT,
                .policy = hwevtq_policy,
                .doit = hwevtq_rx_msg,
                .dumpit = NULL,
	},
};
#else 
static struct genl_ops hwevtq_ops = {
	.cmd = HWEVTQ_CMD_EVENT,
	.policy = hwevtq_policy,
	.doit = hwevtq_rx_msg,
	.dumpit = NULL,
};
#endif

static struct genl_multicast_group hwevtq_mcgrps[] = {
	[HWEVTQ_MCAST_GRP_RES] = { .name = HWEVTQ_MCAST_GRP_RES_NAME, },
	[HWEVTQ_MCAST_GRP_AUDIO] = { .name = HWEVTQ_MCAST_GRP_AUDIO_NAME, },
	[HWEVTQ_MCAST_GRP_BATTERY] = { .name = HWEVTQ_MCAST_GRP_BATTERY_NAME, },
	[HWEVTQ_MCAST_GRP_BUTTON] = { .name = HWEVTQ_MCAST_GRP_BUTTON_NAME, },
	[HWEVTQ_MCAST_GRP_BUTTON_POWER] = { .name = HWEVTQ_MCAST_GRP_BUTTON_POWER_NAME, },
	[HWEVTQ_MCAST_GRP_CAPZONE] = { .name = HWEVTQ_MCAST_GRP_CAPZONE_NAME, },
	[HWEVTQ_MCAST_GRP_HT] = { .name = HWEVTQ_MCAST_GRP_HT_NAME, },
	[HWEVTQ_MCAST_GRP_LED] = { .name = HWEVTQ_MCAST_GRP_LED_NAME, },
	[HWEVTQ_MCAST_GRP_SENSOR] = { .name = HWEVTQ_MCAST_GRP_SENSOR_NAME, },
	[HWEVTQ_MCAST_GRP_TEMP] = { .name = HWEVTQ_MCAST_GRP_TEMP_NAME, },
	[HWEVTQ_MCAST_GRP_WAKEUP] = { .name = HWEVTQ_MCAST_GRP_WAKEUP_NAME, },
};

#if LINUX_VERSION_CODE > KERNEL_VERSION(4,4,0)
static struct genl_family hwevtq_genl_family = {
	.id = GENL_ID_GENERATE,
	.name = HWEVTQ_FAMILY_NAME,
        .version = 1,
        .maxattr = HWEVTQ_MAX_ATTR,
        .netnsok = false,
        .module = THIS_MODULE,
        .ops = hwevtq_ops,
        .n_ops = ARRAY_SIZE(hwevtq_ops),
        .mcgrps = hwevtq_mcgrps,
        .n_mcgrps = ARRAY_SIZE(hwevtq_mcgrps),
};
#else
static struct genl_family hwevtq_genl_family = {
	.id = GENL_ID_GENERATE,
	.name = HWEVTQ_FAMILY_NAME,
        .version = 1,
        .maxattr = HWEVTQ_MAX_ATTR,
        .netnsok = false,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
	.module = THIS_MODULE,
#endif
};
#endif

#endif
