/*
 * Copyright (c) 2018-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * SONOS HDMI control module - private data and functions.
 */

#ifndef HDMICTL_PRIV_H
#define HDMICTL_PRIV_H

#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/sched.h>
#include <linux/iio/iio.h>
#include <linux/debugfs.h>
#include <linux/spinlock.h>

struct hdmictl {
	struct device		*dev;
	dev_t			devno;
	struct cdev		cdev;

	struct _gpio {
		int			power_ctrl_gpio;
		int			arc_hpd_ctrl_gpio;
		int			mipi_hpd_ctrl_gpio;

		int			hpd_gpio;
		int			hpd_last_state;
		int			hpd_gpio_irq_num;
		spinlock_t		hpd_lock;

		int			fault_gpio;
		struct task_struct	*fault_poll_thread;
		int			sim_fault_state;
	} gpio;

	struct _adc {
		struct iio_dev			*iio_dev;
		struct iio_chan_spec const	*channel;
		struct task_struct		*poll_thread;

		u32				songle;
		u32				value;
		u32				thresh_low;
		u32				thresh_high;
	} adc;

	struct dentry		*debugfs_dir;
};

extern int gpio_get_5v_line(struct hdmictl *hdmictl);
extern int gpio_set_5v_line(struct hdmictl *hdmictl, int val);
extern int gpio_set_songle(struct hdmictl *hdmictl, int val);
extern int gpio_get_fault_state(struct hdmictl *hdmictl);
extern int gpio_init(struct hdmictl *hdmictl);
extern void gpio_exit(struct hdmictl *hdmictl);

extern int adc_init(struct hdmictl *hdmictl);
extern void adc_exit(struct hdmictl *hdmictl);

#endif
