#ifndef _SONOS_EXTERNAL_BUILD_H
#define _SONOS_EXTERNAL_BUILD_H
#define BB_MOD_DEBUG

#define BB_LVL_ERR      (0x80000000)
#define BB_LVL_WARNING  (0x40000000)
#define BB_LVL_INFO     (0x20000000)
#define BB_LVL_DEBUG    (0x10000000)
#define BB_LVL_ALL      (0xf0000000)

#define BB_MOD_HDMICTL  (0x00100000)

#define print_blackbox_msg(mod, lvl, fmt, ...) \
{ \
	const char *MOD_STR; \
	const char *LVL_STR; \
	switch (mod) { \
		case BB_MOD_HDMICTL: \
			MOD_STR = "HDMICTL"; \
			break; \
		default: \
			MOD_STR = "UNKNOWN"; \
			break; \
	} \
	switch (lvl) { \
		case BB_LVL_ERR: \
			LVL_STR = "ERR"; \
			break; \
		case BB_LVL_WARNING: \
			LVL_STR = "WARNING"; \
			break; \
		case BB_LVL_INFO: \
			LVL_STR = "INFO"; \
			break; \
		case BB_LVL_DEBUG: \
			LVL_STR = "DEBUG"; \
			break; \
		default: \
			LVL_STR = "UNKNOWN"; \
			break; \
	} \
	printk("<%s,%s> " fmt "\n", MOD_STR, LVL_STR, ##__VA_ARGS__); \
}

#define bb_log_dev(dev, mod, lvl, fmt, args...) \
	print_blackbox_msg(mod, lvl, fmt, ##args)

#define bb_log(mod, lvl, fmt, args...) \
        print_blackbox_msg(mod, lvl, fmt, ##args)

#ifdef BB_MOD_DEBUG
#define bb_log_dbg(mod, fmt, args...) \
	print_blackbox_msg(mod, BB_LVL_DEBUG, "%s@%d: "fmt, __FUNCTION__, __LINE__, ##args)
#define bb_log_dbg_dev(dev, mod, fmt, args...) \
	print_blackbox_msg(mod, BB_LVL_DEBUG, "%s@%d: "fmt, __FUNCTION__, __LINE__, ##args)
#else
#define bb_log_dbg(mod, fmt, args...)
#define bb_log_dbg_dev(dev, mod, fmt, args...)
#endif


enum EventInfo {
  EVTINFO_NO_EVENT,
  EVTINFO_CONNECTED,
  EVTINFO_DISCONNECTED,
  EVTINFO_HW_FAULT
};

enum EventSource {
  EVTSOURCE_NO_SOURCE,
  EVTSOURE_SONGLE,
  EVTSOURCE_HDMI
};


#define event_queue_send_event(source, info)

#endif
