/*
 * Copyright (c) 2018-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef EVENT_QUEUE_H
#define EVENT_QUEUE_H

#include <linux/list.h>
#include <linux/rwsem.h>
#include "event_queue_api.h"

extern struct list_head event_queue_reg_list;
extern int  event_queue_init_proc(void);
extern void event_queue_remove_proc(void);
extern void event_queue_process_regs(enum HWEVTQ_EventSource, enum HWEVTQ_EventInfo);
extern struct list_head event_queue_reg_list;
extern struct rw_semaphore event_queue_reg_lock;
extern struct button_event_queue ** event_queue_get_default_queue(void);

#endif
