#define TDM_FENWAY_GIR 0
#define TDM_RIR_BASE (RIR_RFWM(0)|RIR_RFEN|RIR_RWEN|RIR_RDMA)
#define TDM_TIR_BASE (TIR_TFWM(0)|TIR_TFEN|TIR_TWEN|TIR_TAO|TIR_TDMA)
#define TDM_FENWAY_TIR (TDM_TIR_BASE|TIR_TSO|TIR_TFSD(0)|TIR_TRDO|TIR_TDE)
#define TDM_ANVIL_TIR (TDM_TIR_BASE|TIR_TSO|TIR_TSL|TIR_TCOE|TIR_TRDO|TIR_TFSD(0x01)|TIR_TDE|TIR_TFSE|TIR_TSA)
#define TDM_AMOEBA_TIR (TDM_TIR_BASE|TIR_TSO|TIR_TRDO|TIR_TFSD(1)|TIR_TDE|TIR_TFSE)

#define TDM_FENWAY_TFP (TFP_TNCF(4)|TFP_TCS(CHANNEL_16BIT_LIN))
#define TDM_ANVIL_TFP (TFP_TNCF(2)|TFP_TCS(CHANNEL_16BIT_LIN))
#define TDM_AMOEBA_TFP (TFP_TNCF(2)|TFP_TCS(CHANNEL_16BIT_LIN))

#define TDM_FENWAY_TCEN0 0x0000000F
#define TDM_FENWAY_TCEN1 0
#define TDM_FENWAY_TCEN2 0
#define TDM_FENWAY_TCEN3 0

#define TDM_FENWAY_TCMA0 0
#define TDM_FENWAY_TCMA1 0
#define TDM_FENWAY_TCMA2 0
#define TDM_FENWAY_TCMA3 0

#define TDM_ANVIL_TCEN0 0x00000003
#define TDM_ANVIL_TCEN1 0
#define TDM_ANVIL_TCEN2 0
#define TDM_ANVIL_TCEN3 0

#define TDM_ANVIL_TCMA0 0
#define TDM_ANVIL_TCMA1 0
#define TDM_ANVIL_TCMA2 0
#define TDM_ANVIL_TCMA3 0

#define TDM_AMOEBA_TCEN0 0x00000003
#define TDM_AMOEBA_TCEN1 0
#define TDM_AMOEBA_TCEN2 0
#define TDM_AMOEBA_TCEN3 0

#define TDM_AMOEBA_TCMA0 0
#define TDM_AMOEBA_TCMA1 0
#define TDM_AMOEBA_TCMA2 0
#define TDM_AMOEBA_TCMA3 0

#define TDM_FENWAY_TX_DESCRS 48
#define TDM_FENWAY_TX_BUFLEN_MAX 2048
#define TDM_FENWAY_TX_BUFLEN_DEFAULT 2048
#define TDM_FENWAY_TX_BUFLEN_MIN 2048
#define TDM_FENWAY_TX_FRAMELEN 16
#define TDM_FENWAY_TX_STRIDELEN 8
#define TDM_FENWAY_TX_BUFMOD 16

#define TDM_ANVIL_TX_DESCRS 48
#define TDM_ANVIL_TX_BUFLEN_MAX 192
#define TDM_ANVIL_TX_BUFLEN_DEFAULT 192
#define TDM_ANVIL_TX_BUFLEN_MIN 192
#define TDM_ANVIL_TX_FRAMELEN 8
#define TDM_ANVIL_TX_STRIDELEN 8
#define TDM_ANVIL_TX_BUFMOD 8

#define TDM_AMOEBA_TX_DESCRS 48
#define TDM_AMOEBA_TX_BUFLEN_MAX 2048
#define TDM_AMOEBA_TX_BUFLEN_DEFAULT 2048
#define TDM_AMOEBA_TX_BUFLEN_MIN 2048
#define TDM_AMOEBA_TX_FRAMELEN 16
#define TDM_AMOEBA_TX_STRIDELEN 8

struct device_audio_params devparms_fenway = {
	.dmac_irq = 2,
	.tdm_irq = 0,
	.dmac_err_irq = 1,
	.tir = TDM_FENWAY_TIR,
	.tfp = TDM_FENWAY_TFP,
	.tcen = { TDM_FENWAY_TCEN0, TDM_FENWAY_TCEN1, TDM_FENWAY_TCEN2, TDM_FENWAY_TCEN3 },
	.tcma = { TDM_FENWAY_TCMA0, TDM_FENWAY_TCMA1, TDM_FENWAY_TCMA2, TDM_FENWAY_TCMA3 },
	.tx_descrs = TDM_FENWAY_TX_DESCRS,
	.tx_buflen_min = TDM_FENWAY_TX_BUFLEN_MIN,
	.tx_buflen_max = TDM_FENWAY_TX_BUFLEN_MAX,
	.tx_buflen_default = TDM_FENWAY_TX_BUFLEN_DEFAULT,
	.tx_stridelen = TDM_FENWAY_TX_STRIDELEN,
	.tx_framelen = TDM_FENWAY_TX_FRAMELEN,
	.tx_zerotemplate = { 0, 0, 0, 0, 0, 0, 0, 1,
			     0, 0, 0, 0, 0, 0, 0, 0 }
};

struct device_audio_params devparms_anvil = {
	.dmac_irq = 2,
	.tdm_irq = 0,
	.dmac_err_irq = 1,
	.tir = TDM_ANVIL_TIR,
	.tfp = TDM_ANVIL_TFP,
	.tcen = { TDM_ANVIL_TCEN0, TDM_ANVIL_TCEN1, TDM_ANVIL_TCEN2, TDM_ANVIL_TCEN3 },
	.tcma = { TDM_ANVIL_TCMA0, TDM_ANVIL_TCMA1, TDM_ANVIL_TCMA2, TDM_ANVIL_TCMA3 },
	.tx_descrs = TDM_ANVIL_TX_DESCRS,
	.tx_buflen_min = TDM_ANVIL_TX_BUFLEN_MIN,
	.tx_buflen_max = TDM_ANVIL_TX_BUFLEN_MAX,
	.tx_buflen_default = TDM_ANVIL_TX_BUFLEN_DEFAULT,
	.tx_stridelen = TDM_ANVIL_TX_STRIDELEN,
	.tx_framelen = TDM_ANVIL_TX_FRAMELEN,
	.tx_zerotemplate = { 0, 0, 0, 0, 0, 0, 0, 0 }
};

struct device_audio_params devparms_amoeba = {
	.dmac_irq = 2,
	.tdm_irq = 0,
	.dmac_err_irq = 1,
	.tir = TDM_AMOEBA_TIR,
	.tfp = TDM_AMOEBA_TFP,
	.tcen = { TDM_AMOEBA_TCEN0, TDM_AMOEBA_TCEN1, TDM_AMOEBA_TCEN2, TDM_AMOEBA_TCEN3 },
	.tcma = { TDM_AMOEBA_TCMA0, TDM_AMOEBA_TCMA1, TDM_AMOEBA_TCMA2, TDM_AMOEBA_TCMA3 },
	.tx_descrs = TDM_AMOEBA_TX_DESCRS,
	.tx_buflen_min = TDM_AMOEBA_TX_BUFLEN_MIN,
	.tx_buflen_max = TDM_AMOEBA_TX_BUFLEN_MAX,
	.tx_buflen_default = TDM_AMOEBA_TX_BUFLEN_DEFAULT,
	.tx_stridelen = TDM_AMOEBA_TX_STRIDELEN,
	.tx_framelen = TDM_AMOEBA_TX_FRAMELEN,
	.tx_zerotemplate = { 0, 0, 0, 0, 0, 0, 0, 0,
			     0, 0, 0, 3, 0, 0, 0, 0 }
};

