#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>

struct led_func {
        unsigned char led_slot[8];
        unsigned int  led_flags;
};
#define AUDIODEV_R8OP_LED_FUNC_RESTART          0x00000001

#define LED_DEVICE "/dev/audioctl"

#define LED_WHITE	 			1
#define LED_GREEN	 			2
#define LED_AMBER		 		4
#define LED_RED				8
#define LED_GREEN_BUTTON	0x10
#define LED_OVERRIDE			0x20

#define AUDIOCTL_R8OP_LED_REQUEST     _IOW(252,	\
                                           144, \
                                           int)
#define AUDIOCTL_R8OP_LED_FUNC        _IOW(252, \
                                           155, \
                                           struct led_func)
#define AUDIOCTL_R8OP_SET_LED_PWM _IOW(252, 147, int)

int main(int argc, char **argv)
{
   int fd;
   int ret;
   int i,j;
   char *arg;
   struct led_func func;

   printf("Testing the amazing Fenway LED driver\n\n");

   if (argc == 1) {
      printf("Shutting all LEDs off\n");
      for (i = 0; i < 8; i++) {
         func.led_slot[i] = 0;
      }
      func.led_flags = 0;

      fd = open(LED_DEVICE, O_RDONLY);
      if (fd < 0) {
         printf("error opening device %s\n", LED_DEVICE);
         exit(0);
      }
      printf("file open\n");
      ret = ioctl(fd, AUDIOCTL_R8OP_LED_FUNC, &func);
      if (ret == -1) 
         printf("ERROR: ioctl\n");
      else
         printf("Success\n"); 
      exit(0);
   }

   if (argc == 2) {
      int dutyCycle=20042007;

      if (strcmp(argv[1], "-h") == 0) {
	printf("led-test: no args - turn off the LEDs\n"
		"<duty_cycle>  - set duty cycle 0..255\n"
		"'o'|'O'   'a'|'r'|'g'|'w'   -- led request 'o' overide \n"
		" <pat0> <pat1> <pat3> <pat4> <pat5> <pat6> <pat7> - cycle through the patterns\n"
		" pat? - string of one or more of the following: 'R' - reset ring\n"
		"        'a' - amber, 'r' - red, 'g' - green, 'b' green button, 'w' - white\n"
		"-h  - this help\n");
        exit(0);
      }
      dutyCycle = atoi(argv[1]);
      if ((dutyCycle >= 0) && (dutyCycle <= 255)) {
         fd = open(LED_DEVICE, O_RDONLY);
         if (fd < 0) {
            printf("error opening device %s\n", LED_DEVICE);
            exit(0);
         }
         printf("Setting white LED duty cycle to %d\n", dutyCycle);
         ret = ioctl(fd, AUDIOCTL_R8OP_SET_LED_PWM, &dutyCycle);
         if (ret == -1) 
            printf("ERROR: ioctl\n");
         else
            printf("Success\n"); 
      }
      else printf("illegal duty cycle %d\n", dutyCycle);
      exit(0);
   }

   if (argc == 3) {
	   int ledmask;
	   fd = open(LED_DEVICE, O_RDONLY);
	   if (fd < 0) {
		   printf("error opening device %s\n", LED_DEVICE);
		   exit(0);
	   }
	   ledmask = 0;
	   if (argv[1][0] == 'o') ledmask |= LED_OVERRIDE;
	   if (argv[2][0] == 'w') ledmask |= LED_WHITE;
	   if (argv[2][0] == 'r') ledmask |= LED_RED;
	   if (argv[2][0] == 'a') ledmask |= LED_AMBER;
	   if (argv[2][0] == 'g') ledmask |= LED_GREEN;
	   ret = ioctl(fd, AUDIOCTL_R8OP_LED_REQUEST, &ledmask);
	   if (ret == -1) 
		   printf("ERROR: ioctl\n");
	   else
		   printf("Success\n"); 
	   exit(0);
   }

   if (argc != 9) {
      printf("  only %d args, 8 required\n", argc-1);
      exit(0);
   }

   fd = open(LED_DEVICE, O_RDONLY);
   if (fd < 0) {
      printf("error opening device %s\n", LED_DEVICE);
      exit(0);
   }
   printf("File %s is now open\n\n", LED_DEVICE);
     
   func.led_flags = 0;
   for (i = 0; i < 8; i++) {
      func.led_slot[i] = 0;
      j = 0;
      arg = argv[i+1];
      while (arg[j] != '\0') {
         if (arg[j] == 'R')
            func.led_flags |= AUDIODEV_R8OP_LED_FUNC_RESTART;
         if (arg[j] == 'w')
            func.led_slot[i] |= LED_WHITE;
         if (arg[j] == 'r')
            func.led_slot[i] |= LED_RED;
         if (arg[j] == 'a')
            func.led_slot[i] |= LED_AMBER;
         if (arg[j] == 'g')
            func.led_slot[i] |= LED_GREEN;
         if (arg[j] == 'b')
            func.led_slot[i] |= LED_GREEN_BUTTON;
         j++;
      }
   }

   if (func.led_flags == AUDIODEV_R8OP_LED_FUNC_RESTART)
      printf("Force RESTART\n");
   for (i = 0; i < 8; i++)
      printf("%d: %02x\n", i, func.led_slot[i]);
        
   ret = ioctl(fd, AUDIOCTL_R8OP_LED_FUNC, &func);
   if (ret == -1) 
      printf("ERROR: ioctl\n");
   else
      printf("Success\n"); 
}
