/*
 * Copyright (c) 2010-2019 Sonos Inc.
 * All rights reserved.
 */
#include "audioctl_i2c.h"
#include "audioctl.h"
#include <linux/semaphore.h>
#include <linux/delay.h>
#include "mdp.h"

static DECLARE_MUTEX(audioctl_i2c_lock);

void i2c_initFenwayDevices(void)
{
   struct i2c_adapter *pI2cAdapter;

   pI2cAdapter = i2c_get_adapter(0);

   thermalsensor_InitDriver(pI2cAdapter);

   if (IS_FENWAY) {
      mma7660_InitDriver(pI2cAdapter);
      sta335_InitDriver(pI2cAdapter);
   }
}


int i2c_WriteReg(struct i2c_client *pClient, int regAddr, char *data, unsigned int len)
{
   int ret;
   char writeBuf[I2C_WRITE_MAX_SIZE+1];

   if ((regAddr < 0) || (regAddr > 255)) {
      return -1;
   }
   if (len > I2C_WRITE_MAX_SIZE) {
      return -2;
   }

   writeBuf[0] = (char)regAddr;
   memcpy(&writeBuf[1], data, len);

 	down(&audioctl_i2c_lock);
   ret = i2c_master_send(pClient, writeBuf, len+1);
 	up(&audioctl_i2c_lock);

   if (ret != len+1) {
      return ret;
   }

   return 0;
}

int i2c_ReadReg(struct i2c_client *pClient, int regAddr, char *buf, unsigned int len)
{
   int ret;
   char reg;
   struct i2c_msg msgs[2];

   reg = regAddr;
	msgs[0].addr = pClient->addr;
	msgs[0].flags = pClient->flags & I2C_M_TEN;
	msgs[0].len = 1;
	msgs[0].buf = &reg;

	msgs[1].addr = pClient->addr;
	msgs[1].flags = pClient->flags & I2C_M_TEN;
   msgs[1].flags |= I2C_M_RD;
	msgs[1].len = len;
	msgs[1].buf = buf;

 	down(&audioctl_i2c_lock);
	ret = i2c_transfer(pClient->adapter, msgs, 2);
 	up(&audioctl_i2c_lock);

   if (ret == 2) {
      ret = 0;
   }
   else if (ret == 0) {
      ret = -1;
   }

   return ret;
}

void i2c_GetSem(void)
{
 	down(&audioctl_i2c_lock);
}

void i2c_ReleaseSem(void)
{
 	up(&audioctl_i2c_lock);
}
