/*
 * Copyright (c) 2003-2021 Sonos Inc.
 * All rights reserved.
 */
#undef RRTEST

#include <generated/autoconf.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <linux/watchdog.h>
#include <linux/semaphore.h>
#include <linux/proc_fs.h>
#include "mdp.h"

#include "audioctl.h"
#include "audioctl_pub.h"
#include "audioctl_prv.h"
#include "audioctl_i2c.h"


extern struct file_operations dsp_fops;
extern struct file_operations dsp_mem_fops;
extern struct file_operations i2c_fops;
extern struct file_operations audioctl_fops;

extern void dsp_intr(void);
extern int  dsp_proc_init(void);
extern int  dsp_device_init(void);

extern int i2c_proc_init(void);
extern int i2c_device_init(void);

extern int audioctl_proc_init(void);
extern int audioctl_device_init(void);
extern int audioctl_device_cleanup(void);
extern void audioctl_proc_remove(void);

extern void i2c_initFenwayDevices(void);
extern void thermalsensor_InitEventQueue(struct button_event_queue *beq);

void cleanup_module( void );

int pwm_InitVcxo(void);
int pwm_InitBrightnessLedPwm(void);
void pwm_InitAnvilP3MCLK(void);

int audioctlMajorDevice;
#define AUDIOCTL_NAME "audioctl"

extern int fsl_8xxx_tdm_init(void);

int
init_module( void )
{
   int ret;

    printk("audiodev.ko: init_module %d/%d.\n", (int)sys_mdp.mdp_model,
           (int)sys_mdp.mdp_submodel);
    if (!IS_FENWAY && !IS_ANVIL && !IS_AMOEBA) {
        printk ("This driver only works on products in the Fenway family\n");
        return -EFAULT;
    }

    if (fenway_gpio_is_anvil() && !IS_ANVIL) {
       printk("ABORT: Anvil board with MDP submodel configured for Fenway\n");
       return -EFAULT;
    }

    if (!fenway_gpio_is_anvil() && IS_ANVIL) {
       printk("ABORT: Fenway board with MDP submodel configured for Anvil\n");
       return -EFAULT;
    }

    audioctlMajorDevice = register_chrdev(AUDIOCTL_MAJOR, AUDIOCTL_NAME, &audioctl_fops);
    if (audioctlMajorDevice < 0) {
       printk("Error %d register device %s\n", audioctlMajorDevice, AUDIOCTL_NAME);
    }
    else {
       printk("Device %s successfully registered with major device number %d\n",
              AUDIOCTL_NAME, audioctlMajorDevice);
    }

    if( (ret = audioctl_proc_init()) ) {
       printk("audioctl_proc_init: early exit\n");
        return( ret );
    }
    fenway_gpio_proc_init();

    fsl_8xxx_tdm_init();

    i2c_initFenwayDevices();
    anvil_resetDac();
    if (IS_ANVIL_NOVCXO) pwm_InitAnvilP3MCLK(); else pwm_InitVcxo();

    audioctl_device_init();
    thermalsensor_InitEventQueue(audioctlpriv.button_queue);
    fenway_gpio_setup_irq();

    return 0;
}

void
cleanup_module( void )
{
   thermalsensor_ExitDriver();
   mma7660_ExitDriver();
   sta335_ExitDriver();

   fenway_gpio_cleanup_irq();
   audioctl_proc_remove();
   audioctl_device_cleanup();
   fenway_gpio_proc_remove();

   unregister_chrdev(audioctlMajorDevice, AUDIOCTL_NAME);
}

MODULE_LICENSE ("GPL");
MODULE_AUTHOR ("B. Tober");
MODULE_DESCRIPTION ("Fenway Audio Module.");
