#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include "audioctl_pub.h"
#include "sonos-ctl.h"

#define AUDIOCTL_MAJOR			252
#define AUDIODEV_R8OP_KEYPAD_READ	132
#define AUDIODEV_R8OP_CSI_ENABLE	155
#define AUDIOCTL_R8OP_KEYPAD_READ	_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_KEYPAD_READ, int)

int readfails = 0;

void get_orient_string(button_evt bevent, char *str)
{
    button_evt orient = bevent & SW_POSITION_MASK;
    switch (orient) {
    case SW_POSITION_HORIZONTAL:
        strcpy(str, "Horizontal");
        break;
    case SW_POSITION_VERTICAL:
        strcpy(str, "Vertical");
        break;
    default:
        sprintf(str, "UnknowOrientation-%08x\n", orient);
    }
}

int main()
{
   int fd;
   int res;
   button_evt butt, buttons, evt;
   char orient[40];
   int enable;

   printf("Testing the amazing Fenway button driver\n\n");

   fd = open(BUTTON_DEVICE, O_RDONLY);
   if (fd < 0) {
      printf("error opening device %s\n", BUTTON_DEVICE);
      exit(0);
   }

   butt = 0;
   res = ioctl(fd, AUDIOCTL_R8OP_KEYPAD_READ, &butt);
   if (res == -1) 
      printf("ERROR: ioctl\n");
   else {
       get_orient_string(butt, orient);
       printf("Success, initial keypad read %08x current orientation %s\n", butt, orient);
   } 

   printf("Waiting for buttons to be pressed\n\n");
      
   while(1) {
      res = read(fd, &evt, sizeof(evt));
      if (res != sizeof(evt)) {
          printf("Read: size error, got %d, expected %d\n", res, sizeof(evt));
          if (readfails++ > 4) exit(0);
          else continue;
      }
      buttons = ~evt;
      get_orient_string(evt, orient);
      printf("%08x-%08x: %s-%s-%s-%s\n", buttons, evt,
             (buttons & SW_VOL_UP) ? "UP" : "up", 
             (buttons & SW_VOL_DWN) ? "DOWN" : "down",
             (buttons & SW_MUTE) ? "MUTE" : "mute",
             orient);
   }
}
