/*
 * Copyright (c) 2014-2020 Sonos Inc.
 * All rights reserved.
 */
#ifndef _AUDIODEV_CTLPRV_H
#define _AUDIODEV_CTLPRV_H

#include <linux/spinlock.h> 
#include <linux/wait.h>
#include <linux/timer.h>
#include "hwevent_queue_user_api.h"
#include "button_event.h"

#define FENWAY_BUTTON_MASK      (SW_VOL_UP | SW_VOL_DWN | SW_MUTE)
#define ANVIL_BUTTON_MASK       (SW_VOL_UP | SW_VOL_DWN | SW_MUTE)
#define AMOEBA_BUTTON_MASK      FENWAY_BUTTON_MASK

#define MAX_SIMULATED_SOURCES   2
 
typedef int immap_t;

typedef struct audioctl_private {
	volatile immap_t *immp;
	struct timer_list timer;
	int tm_state[3];
	int tm_val[3];
	int tm_pwm[3];
	int tm_port;
	int tm_pin[3];
	unsigned int dcc_state[2];
	int dcc_val[2];
	int dcc_incr[2];
	int dcc_port[2];
	int dcc_pin[2];
	wait_queue_head_t kwq;
	struct button_event_queue *button_queue;
	unsigned int repeat_time;
	char otpver[32];

	long sysword;
	unsigned uv36_monitor_state;
	unsigned long uv36_monitor_time;
	unsigned thwarn,thwarn_time;
	int thwarn_active;
	unsigned long thwarn_expire;
	unsigned latched_faults;
	unsigned thwarn_count;
	unsigned uv14_count;
#define UV36_TIMER_RUNNING 1
#define UV36_MONITORING 2
	int tm_disabled;
	unsigned clip_relax;
	unsigned long irqcd, irqampf, irqgpio;
	u32 gpio_buttons_mask;

	spinlock_t lock;
        int muteOn;
        int ampPowerOn;
        int ampPowerOverride;
} audioctl_private_t;

extern audioctl_private_t audioctlpriv;

#endif
