/*
 * Copyright (c) 2010-2020 Sonos Inc.
 * All rights reserved.
 *
 * Local I2C audioctl definitions.
 */
#include <linux/i2c.h>
#include "hwevent_queue_user_api.h"

#define MODULATOR1_I2C_ADDRESS           0x1C
#define MODULATOR2_I2C_ADDRESS           0x1D
#define THERMAL_SENSOR_I2C_ADDRESS       0x4e
#define ACCELEROMETER_I2C_ADDRESS        0x4c

#define ETH_THERMAL_SENSOR_I2C_ADDRESS   0x4b
#define CORE_THERMAL_SENSOR_I2C_ADDRESS  0x4d
#define WIFI_THERMAL_SENSOR_I2C_ADDRESS  0x4e
#define CPU_THERMAL_SENSOR_I2C_ADDRESS   0x4f

#define TAS5708_I2C_ADDRESS              0x1b
#define CAP1296_I2C_ADDRESS              0x28
#define ADP8866_I2C_ADDRESS              0x27

#define I2C_WRITE_MAX_SIZE 20

#define STA335_REG_STATUS         0x2d
#define STA335_STATUSREG_PLLUL    0x80
#define STA335_STATUSREG_FAULT    0x40
#define STA335_STATUSREG_UVFAULT  0x20
#define STA335_STATUSREG_OVFAULT  0x10
#define STA335_STATUSREG_OCFAULT  0x08
#define STA335_STATUSREG_OCWARN   0x04
#define STA335_STATUSREG_TFAULT   0x02
#define STA335_STATUSREG_TWARN    0x01


extern void thermalsensor_InitDriver(struct i2c_adapter *pI2cAdapter);
extern void thermalsensor_ExitDriver(void);
extern void thermalsensor_SetDebugTemp(short i2caddr, long longtemp);
extern void thermalsensor_SetFaultTemp(short i2caddr, long longtemp);
extern void thermalsensor_SetWarnTemp(short i2caddr, long longtemp);
extern int  thermalSensor_PrintStatus(char *buf);
extern int  thermalSensor_GetTemperature(int tempSensorInst, int *pCelsiusTemp);
extern long thermalsensor_GetStatus(void);

extern int  mma7660_InitDriver(struct i2c_adapter *pI2cAdapter);
extern int  mma7660_ExitDriver(void);
extern int mma7660_DumpRegs(char *pos);
extern int mma7660_PrintStatus(char *pos);
extern enum HWEVTQ_EventInfo orient_get_current(void);

extern int  sta335_InitDriver(struct i2c_adapter *pI2cAdapter);
extern int  sta335_ExitDriver(void);
extern int  sta335_DumpRegs(char *pos);
extern int  sta335_WriteReg(int sta335Id, int reg, char data);
extern int  sta335_ReadReg(int sta335Id, int reg, char *data);
extern void sta335_GetDeviceStatus(int sta335Id, int *pSta335Status);
extern int  sta335_ResetModulators(void);
extern int  sta335_GetDebugMode(int sta335Id);
extern void sta335_SetDebugMode(int sta335Id, int mode);
extern void sta335_mute(int on);

int i2c_WriteReg(struct i2c_client *pClient, int regAddr, char *data, unsigned int len);
int i2c_ReadReg(struct i2c_client *pClient, int regAddr, char *buf, unsigned int len);
void i2c_ShutdownDevices(void);
extern void i2c_GetSem(void);
extern void i2c_ReleaseSem(void);
