/*
 * Copyright (c) 2004-2020 Sonos, Inc.
 * All rights reserved.
 */
#ifndef _AUDIODEV_CTL_H
#define _AUDIODEV_CTL_H

#include "audioctl_pub.h"
#include "hwevent_queue_user_api.h"

struct led_func {
	unsigned char   led_slot[8];
	unsigned int    led_flags;
};

struct time_formats {
    unsigned long long  jiffies;
    unsigned long       timeofday_sec;
    unsigned long       timeofday_usec;
    unsigned long       kernel_stamp;
};

#define SEN_NODEV	-213
#define SEN_ERROR	-212
#define SEN_RANGE	-211

enum AUDIOCTL_TEMPERATURE_SENSORS {
    AUDIOCTL_CPU_TEMPERATURE_SENSOR = 0,
    AUDIOCTL_AMP_TEMPERATURE_SENSOR,
    AUDIOCTL_SOC_TEMPERATURE_SENSOR,
    AUDIOCTL_MAX_AVAILABLE_TEMPERATURE_SENSORS
};

#define AUDIODEV_R8OP_LED_FUNC_RESTART		0x00000001

#define AUDIODEV_CTL_NOP			1
#define AUDIODEV_CTL_FLUSH			2
#define AUDIODEV_CTL_MUX_LOOPBACK		3
#define AUDIODEV_CTL_LINE_MUTE			4
#define AUDIODEV_CTL_SUBW_STATUS		5
#undef AUDIODEV_CTL_CLKPULL
#define AUDIODEV_CTL_AMP_CHECK_STATUS		7
#define AUDIODEV_CTL_AMP_SET_OVLD_THRESHOLD	8
#define AUDIODEV_CTL_AMP_FAULT			9
#define AUDIODEV_CTL_AMP_THERMAL		10
#define AUDIODEV_CTL_AMP_MUTED			11
#define AUDIODEV_CTL_AMP_MUTE			12
#define AUDIODEV_CTL_CS42416_HIGHPASS_FILTER	13
#define AUDIODEV_CTL_CS42416_READ_PEAK		14
#define AUDIODEV_CTL_CS42416_POWERDOWN		15
#define AUDIODEV_CTL_CS42416_MUTE		16
#define AUDIODEV_CTL_CS42416_GET_VOLUME		17
#define AUDIODEV_CTL_CS42416_SET_VOLUME		18
#define AUDIODEV_CTL_DSP_RESET			19
#define AUDIODEV_CTL_DSP_ENABLE			20
#define AUDIODEV_CTL_SET_ZERO_ERROR_LEVEL	21
#define AUDIODEV_CTL_GET_ZERO_ERROR_LEVEL	22
#define AUDIODEV_CTL_CS42416_RESET		23
#define AUDIODEV_CTL_CS42416_READ_REG		24
#define AUDIODEV_CTL_CS42416_WRITE_REG		25
#define AUDIODEV_CTL_GET_INPUT_STATUS		26
#define AUDIODEV_CTL_FULL_AUDIO_STATUS		27
#define AUDIODEV_CTL_AMP_PWR			28
#define AUDIODEV_CTL_VERSION_QUERY		29
#define AUDIODEV_CTL_TEMPERATURE		30
#define AUDIODEV_CTL_LINE_MON			31
#define AUDIODEV_CTL_CURRENT_MON		32
#define AUDIODEV_CTL_AMP_OVLD			33

#define AUDIODEV_R8OP_OLD_VERSION_QUERY		34

#define AUDIODEV_CTL_OVERRIDE_ZERO_ERROR_LEVEL	35
#define AUDIODEV_CTL_STORE_ZERO_ERROR_LEVEL		36
#define AUDIODEV_CTL_VOL_RAMP			37
#define AUDIODEV_CTL_SET_HDWR_VOL			38

#define AUDIODEV_CTL_ERASE_FLASH			39
#define AUDIODEV_CTL_WRITE_FLASH			40
#define AUDIODEV_CTL_READ_FLASH				41
#define AUDIODEV_CTL_GO_FLASH_MODE			42
#define AUDIODEV_CTL_GO_USER_MODE			43
#define AUDIODEV_CTL_SYSTEM_STATUS			44
#define AUDIODEV_OTP_READ_VERSION			45
#define AUDIODEV_CTL_MISCIO_SET				46
#define AUDIODEV_CTL_MISCIO_GET				47
#define AUDIODEV_CTL_DCCAL				48
#define AUDIODEV_CTL_PS36_PWR				49
#define AUDIODEV_CTL_SET_DCOFS				52
#define AUDIODEV_CTL_HEADPHONE_MODE			53
#define AUDIODEV_CTL_HEADPHONE_MUTE			54
#define AUDIODEV_CTL_CLKPULL_HIGHRES			55
#define AUDIODEV_CTL_GET_TIMESTAMP			56
#define AUDIODEV_GET_BUTTON_STATE			62
#define AUDIODEV_GET_REPEAT_TIME			63
#define AUDIODEV_SET_REPEAT_TIME			64

#define AUDIOCTL_EVENT_REQUEST			127

#define R8OP_OFFSET		  	128
#define R8_AUDIOCTL_EVENT_REQUEST		AUDIOCTL_EVENT_REQUEST + R8OP_OFFSET

#define AUDIODEV_R8OP_COMPATIBILITY_TEST	128

#define AUDIODEV_R8OP_NOP				129	
#define AUDIODEV_R8OP_FLUSH 			130	
#define AUDIODEV_R8OP_VERSION_QUERY		131
#define AUDIODEV_R8OP_KEYPAD_READ		132	
#define AUDIODEV_R8OP_TEMP_READ			133
#define AUDIODEV_R8OP_SW_READ_REG		134
#define AUDIODEV_R8OP_SW_WRITE_REG		135
#define AUDIODEV_R8OP_SW_WRITE_STATIC_MAC_ADDR	136
#define AUDIODEV_R8OP_SW_READ_STATIC_MAC_ADDR	137
#define AUDIODEV_R8OP_SW_READ_DYNAMIC_MAC_ADDR	138
#define AUDIODEV_R8OP_SW_READ_MIB		139	
#define AUDIODEV_R8OP_SYS_RESET_1		140
#define AUDIODEV_R8OP_SYS_RESET_2		141
#define AUDIODEV_R8OP_SERNO_READ		142	
#define AUDIODEV_R8OP_READ_EVENT		143
#define AUDIODEV_R8OP_LED_REQUEST		144
#define AUDIODEV_R8OP_LED_FUNC  		155


#define AUDIODEV_R8OP_SET_VCXO_PWM		146
#define AUDIODEV_R8OP_SET_LED_PWM		147
#define AUDIODEV_R8OP_CS4265_READ_REG		148
#define AUDIODEV_R8OP_CS4265_WRITE_REG		149
#define AUDIODEV_R8OP_GET_LINEDET		150
#define AUDIODEV_R8OP_DSP_ENABLE		151
#define AUDIODEV_R8OP_DSP_RESET			152
#define AUDIODEV_R8OP_CODEC_ENABLE		153
#define AUDIODEV_R8OP_CODEC_RESET		154

#define SIZE_OF_STATIC_MAC_ENTRY	8


#define SIZE_OF_DYNAMIC_MAC_ENTRY	9

#define AUDIOCTL_NOP						_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_NOP)
#define AUDIOCTL_FLUSH						_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_FLUSH)

#define AUDIOCTL_MUX_LOOPBACK				_IOW(AUDIOCTL_MAJOR,  AUDIODEV_CTL_MUX_LOOPBACK, int)
#define AUDIOCTL_LINE_MUTE					_IOW(AUDIOCTL_MAJOR,  AUDIODEV_CTL_LINE_MUTE, int)
#define AUDIOCTL_SUBW_STATUS				_IOR(AUDIOCTL_MAJOR,  AUDIODEV_CTL_SUBW_STATUS, int)

#define AUDIOCTL_CLKPULL_HIGHRES					_IOW(AUDIOCTL_MAJOR,  AUDIODEV_CTL_CLKPULL_HIGHRES, int)

#define AUDIOCTL_AMP_CHECK_STATUS			_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_CHECK_STATUS, int)
#define AUDIOCTL_AMP_SET_OVLD_THRESHOLD		_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_SET_OVLD_THRESHOLD, int)
#define AUDIOCTL_AMP_FAULT					_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_FAULT, int)
#define AUDIOCTL_AMP_THERMAL				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_THERMAL, int)
#define AUDIOCTL_AMP_MUTED					_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_MUTED, int)
#define AUDIOCTL_AMP_MUTE					_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_MUTE, int)
#define AUDIOCTL_HEADPHONE_MODE				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_HEADPHONE_MODE, int)
#define AUDIOCTL_HEADPHONE_MUTE				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_HEADPHONE_MUTE, int)
#define AUDIOCTL_AMP_PWR					_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_PWR, int)

#define AUDIOCTL_CS42416_HIGHPASS_FILTER	_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_HIGHPASS_FILTER, int)
#define AUDIOCTL_CS42416_READ_PEAK			_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_READ_PEAK, int)
#define AUDIOCTL_CS42416_POWERDOWN			_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_POWERDOWN, int)
#define AUDIOCTL_CS42416_MUTE				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_MUTE, int)
#define AUDIOCTL_CS42416_GET_VOLUME			_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_GET_VOLUME, int)
#define AUDIOCTL_CS42416_SET_VOLUME			_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_SET_VOLUME, int)
#define AUDIOCTL_CS42416_RESET				_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_RESET)
#define AUDIOCTL_CS42416_READ_REG			_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_READ_REG, int)
#define AUDIOCTL_CS42416_WRITE_REG			_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_CS42416_WRITE_REG, int)
#define AUDIOCTL_SET_ZERO_ERROR_LEVEL		_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_SET_ZERO_ERROR_LEVEL)
#define AUDIOCTL_GET_ZERO_ERROR_LEVEL		_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_GET_ZERO_ERROR_LEVEL, int)
#define AUDIOCTL_OVERRIDE_ZERO_ERROR_LEVEL	_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_OVERRIDE_ZERO_ERROR_LEVEL, int)
#define AUDIOCTL_STORE_ZERO_ERROR_LEVEL		_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_STORE_ZERO_ERROR_LEVEL, int)
#define AUDIOCTL_VOL_RAMP					_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_VOL_RAMP, unsigned char[8] )
#define AUDIOCTL_SET_HDWR_VOL				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_SET_HDWR_VOL, int)
#define AUDIOCTL_ERASE_FLASH				_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_ERASE_FLASH, int)
#define AUDIOCTL_WRITE_FLASH				_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_WRITE_FLASH, int)
#define AUDIOCTL_READ_FLASH					_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_READ_FLASH, int)
#define AUDIOCTL_GO_FLASH_MODE				_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_GO_FLASH_MODE)
#define AUDIOCTL_GO_USER_MODE				_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_GO_USER_MODE)
#define AUDIOCTL_SYSTEM_STATUS				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_SYSTEM_STATUS, int)

#define AUDIOCTL_DSP_RESET					_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_DSP_RESET)
#define AUDIOCTL_DSP_ENABLE					_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_DSP_ENABLE)
#define AUDIOCTL_VERSION_QUERY				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_VERSION_QUERY, int)
#define AUDIOCTL_GET_INPUT_STATUS			_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_GET_INPUT_STATUS, int)
#define AUDIOCTL_FULL_AUDIO_STATUS			_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_FULL_AUDIO_STATUS, int)
#define AUDIOCTL_TEMPERATURE				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_TEMPERATURE, int[AUDIOCTL_MAX_AVAILABLE_TEMPERATURE_SENSORS])
#define AUDIOCTL_LINE_MON					_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_LINE_MON, int)
#define AUDIOCTL_PWR_LOSS					_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_LINE_MON, int)
#define AUDIOCTL_CURRENT_MON				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_CURRENT_MON, int)
#define AUDIOCTL_AMP_OVLD					_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_AMP_OVLD, int)

#define AUDIOCTL_COMPATIBILITY_R8OP_VERSION	_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_OLD_VERSION_QUERY, int)

#define AUDIOCTL_R8OP_COMPAT_TEST			_IO(AUDIOCTL_MAJOR, AUDIODEV_R8OP_COMPATIBILITY_TEST)
#define AUDIOCTL_R8OP_NOP					_IO(AUDIOCTL_MAJOR, AUDIODEV_R8OP_NOP)
#define AUDIOCTL_R8OP_FLUSH					_IO(AUDIOCTL_MAJOR, AUDIODEV_R8OP_FLUSH)
#define AUDIOCTL_R8OP_VERSION_QUERY			_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_VERSION_QUERY, int)
#define AUDIOCTL_R8OP_KEYPAD_READ			_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_KEYPAD_READ, int)
#define AUDIOCTL_R8OP_TEMP_READ				_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_TEMP_READ, int)

#define AUDIOCTL_SW_READ_REG				_IOWR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SW_READ_REG, int)
#define AUDIOCTL_SW_WRITE_REG				_IOWR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SW_WRITE_REG, int)
#define AUDIOCTL_SW_WRITE_STATIC_MAC_ADDR	_IOWR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SW_WRITE_STATIC_MAC_ADDR, SIZEOF_STATIC_MAC_ENTRY)

#define AUDIOCTL_SW_READ_STATIC_MAC_ADDR	_IOWR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SW_READ_STATIC_MAC_ADDR, SIZEOF_STATIC_MAC_ENTRY)

#define AUDIOCTL_SW_READ_DYNAMIC_MAC_ADDR	_IOWR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SW_READ_DYNAMIC_MAC_ADDR, SIZEOF_DYNAMIC_MAC_ENTRY)

#define AUDIOCTL_R8OP_SW_READ_MIB			_IOWR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SW_READ_MIB, int)

#define AUDIOCTL_R8OP_SYS_RESET_1			_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_R8OP_SYS_RESET_1)
#define AUDIOCTL_R8OP_SYS_RESET_2			_IO(AUDIOCTL_MAJOR, AUDIODEV_CTL_R8OP_SYS_RESET_2)
#define AUDIOCTL_R8OP_SERNO_READ			_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SERNO_READ, int)
#define AUDIOCTL_R8OP_READ_EVENT			_IOR(AUDIOCTL_MAJOR, AUDIODEV_R8OP_READ_EVENT, int)
#define AUDIOCTL_R8OP_LED_REQUEST			_IOW(AUDIOCTL_MAJOR, AUDIODEV_R8OP_LED_REQUEST, int)
#define AUDIOCTL_R8OP_LED_FUNC				_IOW(AUDIOCTL_MAJOR, AUDIODEV_R8OP_LED_FUNC, struct led_func )
#define AUDIOCTL_R8OP_SET_LED_PWM			_IOW(AUDIOCTL_MAJOR, AUDIODEV_R8OP_SET_LED_PWM, int)
#define AUDIOCTL_R8OP_CODEC_ENABLE			_IO(AUDIOCTL_MAJOR, AUDIODEV_R8OP_CODEC_ENABLE)
#define AUDIOCTL_R8OP_CODEC_RESET			_IO(AUDIOCTL_MAJOR, AUDIODEV_R8OP_CODEC_RESET)
#define AUDIOCTL_OTP_READ_VERSION			_IOR(AUDIOCTL_MAJOR, AUDIODEV_OTP_READ_VERSION, char[32] )
#define AUDIOCTL_MISCIO_SET				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_MISCIO_SET, long[2] )
#define AUDIOCTL_MISCIO_GET				_IOWR(AUDIOCTL_MAJOR, AUDIODEV_CTL_MISCIO_GET, long )
#define AUDIOCTL_DCCAL					_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_DCCAL,long[2])
#define AUDIOCTL_PS36_PWR				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_PS36_PWR, int)
#define AUDIOCTL_SET_SYS_WORD				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_SET_SYS_WORD, long)
#define AUDIOCTL_GET_SYS_WORD				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_GET_SYS_WORD, long)
#define AUDIOCTL_SET_DCOFS				_IOW(AUDIOCTL_MAJOR, AUDIODEV_CTL_SET_DCOFS, int[3])

#define AUDIOCTL_GET_TIMESTAMP				_IOR(AUDIOCTL_MAJOR, AUDIODEV_CTL_GET_TIMESTAMP, struct time_formats)
#define AUDIOCTL_GET_BUTTON_STATE		_IOR(AUDIOCTL_MAJOR, AUDIODEV_GET_BUTTON_STATE, int[HWEVTQSOURCE_NUM_SOURCES])
#define AUDIOCTL_GET_REPEAT_TIME		_IOR(AUDIOCTL_MAJOR, AUDIODEV_GET_REPEAT_TIME, int)
#define AUDIOCTL_SET_REPEAT_TIME		_IOW(AUDIOCTL_MAJOR, AUDIODEV_SET_REPEAT_TIME, int)

#define SYSTAT_AMP_CURRENT_FAULT_STATUS			0x01
#define SYSTAT_AMP_CURRENT_WARN_STATUS			0x02
#define SYSTAT_AMP_FAULT_STATUS					0x04
#define SYSTAT_AMP_FAULT_WARN_STATUS			0x08
#define SYSTAT_AMP_THERMAL_FAULT_STATUS	   0x10
#define SYSTAT_AMP_THERMAL_WARN_STATUS			0x20
#define SYSTAT_AMP_OVLD_FAULT_STATUS			0x40
#define SYSTAT_AMP_OVLD_WARN_STATUS				0x80
#define SYSTAT_AMP_PWR_STATUS					0x100
#define SYSTAT_AMP_MUTE_STATUS					0x200
#define SYSTAT_UNUSED_UNUSED_UNUSED				0x400
#define SYSTAT_SUBWOOFER_STATUS					0x800
#define SYSTAT_HEADPHONE_STATUS					0x800
#define SYSTAT_INPUT_CONNECTED_STATUS			0x1000
#define SYSTAT_CODEC_MUTE_CHAN1					0x2000
#define SYSTAT_CODEC_MUTE_CHAN2					0x4000
#define SYSTAT_CODEC_MUTE_CHAN3					0x8000
#define SYSTAT_AUDIO_FAULT_TEMPERATURE_STATUS	0x10000
#define SYSTAT_AUDIO_WARN_TEMPERATURE_STATUS	0x20000
#define SYSTAT_CPU_FAULT_TEMPERATURE_STATUS		0x40000
#define SYSTAT_CPU_WARN_TEMPERATURE_STATUS		0x80000
#define SYSTAT_PS36_FAULT_STATUS			0x100000
#define SYSTAT_UV36_FAULT_STATUS			0x200000
#define SYSTAT_UV14_FAULT_STATUS			0x400000
#define SYSTAT_CPU2_FAULT_TEMPERATURE_STATUS		0x800000
#define SYSTAT_CPU2_WARN_TEMPERATURE_STATUS		0x1000000
#define SYSTAT_AMP_CLOCK_ERROR_STATUS			0x2000000
#define SYSTAT_SOC_FAULT_TEMPERATURE_STATUS     0x4000000
#define SYSTAT_SOC_WARN_TEMPERATURE_STATUS      0x8000000
#define SYSTAT_POWER_FAULT_TEMPERATURE_STATUS     0x10000000
#define SYSTAT_POWER_WARN_TEMPERATURE_STATUS      0x20000000
#define SYSTAT_MOTION_FAULT_TEMPERATURE_STATUS          0x40000000
#define SYSTAT_MOTION_WARN_TEMPERATURE_STATUS           0x80000000


#define ANVIL_AMP_FAULT_TEMPERATURE			0
#define ANVIL_AMP_WARN_TEMPERATURE			0
#define FENWAY_CPU_FAULT_TEMPERATURE			89
#define FENWAY_CPU_WARN_TEMPERATURE			79
#define ANVIL_CPU_FAULT_TEMPERATURE			80
#define ANVIL_CPU_WARN_TEMPERATURE			75
#define ANVIL_CPU2_FAULT_TEMPERATURE			0
#define ANVIL_CPU2_WARN_TEMPERATURE			0
#define AMOEBA_CPU_FAULT_TEMPERATURE			86
#define AMOEBA_CPU_WARN_TEMPERATURE			0

#define R_WARN_MASK             (SYSTAT_AMP_CURRENT_WARN_STATUS        | \
                                 SYSTAT_AMP_FAULT_WARN_STATUS          | \
                                 SYSTAT_AUDIO_WARN_TEMPERATURE_STATUS  | \
                                 SYSTAT_CPU_WARN_TEMPERATURE_STATUS    | \
                                 SYSTAT_CPU2_WARN_TEMPERATURE_STATUS   | \
                                 SYSTAT_SOC_WARN_TEMPERATURE_STATUS    | \
                                 SYSTAT_POWER_WARN_TEMPERATURE_STATUS )

#define R_FAULT_MASK            (SYSTAT_AMP_CURRENT_FAULT_STATUS       | \
                                 SYSTAT_AMP_FAULT_STATUS               | \
                                 SYSTAT_AUDIO_FAULT_TEMPERATURE_STATUS | \
                                 SYSTAT_CPU_FAULT_TEMPERATURE_STATUS   | \
                                 SYSTAT_CPU2_FAULT_TEMPERATURE_STATUS  | \
                                 SYSTAT_SOC_FAULT_TEMPERATURE_STATUS   | \
                                 SYSTAT_POWER_FAULT_TEMPERATURE_STATUS | \
                                 SYSTAT_PS36_FAULT_STATUS              | \
                                 SYSTAT_UV36_FAULT_STATUS              | \
                                 SYSTAT_UV14_FAULT_STATUS)

#define AMP_FAULT_STATUS					0x01
#define AMP_THERMAL_STATUS					0x02
#define AMP_OVLD_STATUS						0x04
#define AMP_VOLUME_PROBLEM					0x08
#define AMP_PWR_STATUS						0x10
#define AUDIO_MUTE_STATUS					0x20
#define SUBWOOFER_STATUS					0x40
#define INPUT_CONNECTED_STATUS				0x80
#define AUDIO_LOOPBACK_STATUS				0x100
#define CODEC_MUTE_CHAN1					0x200
#define CODEC_MUTE_CHAN2					0x400
#define CODEC_MUTE_CHAN3					0x800
#define AMP_MUTE_STATUS						0x1000

#define COMPAT_AMP_FAULT_STATUS            0x01
#define COMPAT_AMP_THERMAL_STATUS          0x02
#define COMPAT_AMP_OVLD_STATUS             0x04
#define COMPAT_AMP_VOLUME_PROBLEM          0x08
#define COMPAT_AMP_PWR_STATUS              0x10
#define COMPAT_AUDIO_MUTE_STATUS           0x20
#define COMPAT_SUBWOOFER_STATUS            0x40
#define COMPAT_INPUT_CONNECTED_STATUS      0x80
#define COMPAT_AUDIO_LOOPBACK_STATUS       0x100
#define COMPAT_CODEC_MUTE_CHAN1            0x200
#define COMPAT_CODEC_MUTE_CHAN2            0x400
#define COMPAT_CODEC_MUTE_CHAN3            0x800
#define COMPAT_AMP_MUTE_STATUS             0x1000

#define STA335_LEFT  0
#define STA335_RIGHT 1

#define STA335_DEBUG_OFF    0
#define STA335_DEBUG_WARN   1
#define STA335_DEBUG_FAULT  2


void fenway_assertModulatorReset(void);
void fenway_removeModulatorReset(void);
void anvil_setWhiteLedPinsPwm(void);
void anvil_setWhiteLedPinsGpio(void);
int fenway_gpio_setup_irq(void);
void fenway_gpio_cleanup_irq(void);
void fenway_gpio_proc_init(void);
void fenway_gpio_proc_remove(void);
int fenway_gpio_is_anvil(void);
void fenway_gpio_get_buttons(enum HWEVTQ_EventInfo *play_pause, enum HWEVTQ_EventInfo *vol_up, enum HWEVTQ_EventInfo *vol_down);
void audioctl_mute(int on);
int anvil_gpio_amp_temp_warn(void);
int anvil_gpio_amp_shutdown(void);
void anvil_muteDac(int mute);
void anvil_muteAmp(int mute);
void anvil_resetDac(void);
void anvil_resetAmp(void);
void anvil_amp_power(int);
void amoeba_resetAmp(void);
int amoeba_muteAmp(int on);
void amoeba_dac_xsmt(int active);
int amoeba_amp_power(int active);

#define LED_WHITE	 			1
#define LED_GREEN	 			2
#define LED_AMBER		 		4
#define LED_RED				8
#define LED_GREEN_BUTTON	0x10
#define LED_OVERRIDE			0x20

#define AUDIOCTL_POLL_TIME (HZ/20)

#endif
