/*
 * This file only covers MPC8xxx TDM implementations of the LLA.
 */

#ifndef TDM_SHARED_H
#define TDM_SHARED_H

#define TDM_SETMODE_INPUT	0x1
#define TDM_SETMODE_OUTPUT	0x2

#define ZEROPAT_SIZE		64

// sizeof(struct tdm_descr) must be a multiple of 32 - if adding fields
// be sure to tweak reserved appropriately
// Validated by fsl_8xxx_tdm_probe()
struct tdm_descr {
	volatile u32 pd[8];		// 0  - TDM DMAC Transfer Control Descriptor Words (TCDW)
	u32 self;			// 32 - index number for this descriptor
	volatile u32 dno;		// 36 - descriptor number
	volatile u64 dsc;		// 40 - starting frame number
	volatile u32 buf_ll;		// 48 - length of the payload
	volatile u32 buf_clocks;	// 52 - frames in the payload
	u32 buf;			// 56 - Either 0 (silence buffer) or a byte offset to the audio buffer in the ring
	u8 reserved[4];			// 60 - Pad out to a 32-byte boundary
};

struct tdm_shared {
	struct tdm_shared *this_k;	// kernel virtual address to this structure
	struct tdm_shared *this_u;	// user virtual address to this structure
	dma_addr_t this_p;		// physical address of this structure
	u32 nds;			// number of descriptors in the ring
	struct tdm_descr *descrs_k;	// kernel virtual address to tdm_descr
	struct tdm_descr *descrs_u;	// user virtual address to tdm_descr (macro RX_RING)
	dma_addr_t descrs_p;		// physical address to tdm_descr
	u32 dh_active;			// head of the active descriptor list (macro RX_PRD)
	u32 dh_consumer;		// last consumed buffer/next buffer to be consumed (macro RX_CON)
	void *buffers_k;		// kernel virtual address of buffers
	void *buffers_u;		// user virtual address of buffers
	dma_addr_t buffers_p;		// physical address of buffers
	u32 buffer_physlen;		// physical length of each TX buffers, incl. header
	u32 buffer_ll;			// allocation logical length, for RX

	u32 flags;			// runtime state flags (see below)
#define TDM_SHARED_FLAG_RUNNING 0x00000001
#define TDM_SHARED_FLAG_OVERRUN 0x00000002

	// framelen and stridelen must be integer multiples of 8
	// either framelen must be an integer multiple of stridelen or
	// stridelen must be an integer multiple of framelen
	// each individual buffer logical length must be an integer multiple
	// of the larger of framelen or stridelen
	u32 framelen;			// TDM frame length as in FIFO, in bytes
	u32 stridelen;			// DMA stride length in bytes

	u32 clocks_per_buffer;		// audio frames per buffer
	u64 polltime;			// descriptor number userspace is waiting (polling) to enter the sliding window
	u32 latency;			// user configured maximum audio latency
	u32 underflows;			// the number of times the silence buffer has been played
	u8 zeropat[ZEROPAT_SIZE];	// pre-formated silence for zeroing buffers
	u32 buffer_ll_min;		// Minimum length of an audio buffer, in bytes
	u32 buffer_ll_max;		// Maximum length of an audio buffer, in bytes
	u32 buffer_ll_default;		// Default length of an audio buffer, in bytes
	u32 u_cursor;			// user-only. current buffer index (in the ring) being written by userspace
	u32 u_dno;			// user-only. current descriptor number being written by userspace
	u64 u_ftime;			// user-only. last audio frame committed by userspace

	u32 error;			// indicates if rx has stopped (set by driver, reset by user)
#define TDM_ERROR_NONE 0
#define TDM_ERROR_STOPPED 1
};

#endif //TDM_SHARED_H
