#define TDM_LIMELIGHT_GIR 0
#define TDM_RIR_BASE (RIR_RFWM(0)|RIR_RFEN|RIR_RWEN|RIR_RDMA)
#define TDM_TIR_BASE (TIR_TFWM(0)|TIR_TFEN|TIR_TWEN|TIR_TAO|TIR_TDMA)
#define TDM_LIMELIGHT_RIR (TDM_RIR_BASE|RIR_RFSD(0)|RIR_RDE|RIR_RFSE)
#define TDM_LIMELIGHT_TIR (TDM_TIR_BASE|TIR_TFSD(0)|TIR_TFSE|TIR_TRDO)

#define TDM_LIMELIGHT_RFP (RFP_RNCF(4)|RFP_RCS(CHANNEL_16BIT_LIN))
#define TDM_LIMELIGHT_TFP (TFP_TNCF(32)|TFP_TCS(CHANNEL_16BIT_LIN))

#define TDM_LIMELIGHT_RCEN0 0x0000000F
#define TDM_LIMELIGHT_RCEN1 0
#define TDM_LIMELIGHT_RCEN2 0
#define TDM_LIMELIGHT_RCEN3 0

#define TDM_LIMELIGHT_TCEN0 0x03FF03FF
#define TDM_LIMELIGHT_TCEN1 0
#define TDM_LIMELIGHT_TCEN2 0
#define TDM_LIMELIGHT_TCEN3 0

#define TDM_LIMELIGHT_TCMA0 0
#define TDM_LIMELIGHT_TCMA1 0
#define TDM_LIMELIGHT_TCMA2 0
#define TDM_LIMELIGHT_TCMA3 0

#define TDM_LIMELIGHT_RX_DESCRS 16
#define TDM_LIMELIGHT_RX_BUFLEN_MAX 2048
#define TDM_LIMELIGHT_RX_BUFLEN_MIN 1024
#define TDM_LIMELIGHT_RX_FRAMELEN 8
#define TDM_LIMELIGHT_RX_STRIDELEN 8

#define TDM_LIMELIGHT_TX_DESCRS 45
#define TDM_LIMELIGHT_TX_BUFLEN_MAX 5120
#define TDM_LIMELIGHT_TX_BUFLEN_MIN 5120
#define TDM_LIMELIGHT_TX_BUFLEN_DEFAULT 5120
#define TDM_LIMELIGHT_TX_FRAMELEN 40
#define TDM_LIMELIGHT_TX_STRIDELEN 8


struct device_audio_params devparms_limelight = {
	.dmac_irq = 2,
	.tdm_irq = 0,
	.dmac_err_irq = 1,
	.rir = TDM_LIMELIGHT_RIR,
	.tir = TDM_LIMELIGHT_TIR,
	.rfp = TDM_LIMELIGHT_RFP,
	.tfp = TDM_LIMELIGHT_TFP,
	.rcen = { TDM_LIMELIGHT_RCEN0, TDM_LIMELIGHT_RCEN1, TDM_LIMELIGHT_RCEN2, TDM_LIMELIGHT_RCEN3 },
	.tcen = { TDM_LIMELIGHT_TCEN0, TDM_LIMELIGHT_TCEN1, TDM_LIMELIGHT_TCEN2, TDM_LIMELIGHT_TCEN3 },
	.tcma = { TDM_LIMELIGHT_TCMA0, TDM_LIMELIGHT_TCMA1, TDM_LIMELIGHT_TCMA2, TDM_LIMELIGHT_TCMA3 },
	.rx_descrs = TDM_LIMELIGHT_RX_DESCRS,
	.rx_buflen_default = TDM_LIMELIGHT_RX_BUFLEN_MIN,
	.rx_buflen_min = TDM_LIMELIGHT_RX_BUFLEN_MIN,
	.rx_buflen_max = TDM_LIMELIGHT_RX_BUFLEN_MAX,
	.rx_stridelen = TDM_LIMELIGHT_RX_STRIDELEN,
	.rx_framelen = TDM_LIMELIGHT_RX_FRAMELEN,
	.tx_descrs = TDM_LIMELIGHT_TX_DESCRS,
	.tx_buflen_min = TDM_LIMELIGHT_TX_BUFLEN_MIN,
	.tx_buflen_max = TDM_LIMELIGHT_TX_BUFLEN_MAX,
	.tx_buflen_default = TDM_LIMELIGHT_TX_BUFLEN_DEFAULT,
	.tx_stridelen = TDM_LIMELIGHT_TX_STRIDELEN,
	.tx_framelen = TDM_LIMELIGHT_TX_FRAMELEN,
	.tx_zerotemplate = { 0, 0, 0, 0, 0, 0, 0, 0,
	                     0, 0, 0, 0, 0, 0, 0, 0,
	                     0, 0, 0, 0, 0, 0, 0, 0,
	                     0, 0, 0, 0, 0, 0, 0, 0,
	                     0, 0, 0, 0, 0, 0, 0, 0 }
};
