/*
 * drivers/misc/mpc8xxxtdm.h
 *
 * Copyright (C) 2007-2008 Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Created by P. V. Suresh <pala@freescale.com>
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MPC8xxxTDM_H
#define MPC8xxxTDM_H

struct tdm_priv {
	struct tdm_regs __iomem *tdm_regs;	// TDM control/status registers
	struct tdm_data __iomem *data_regs;	// TDM Tx/Rx registers
	struct dmac_regs __iomem *dmac_regs;	// DMA registers
	struct tdm_clock __iomem *clk_regs;	// TDM clock registers
	u32 ptdm_base;				// Base physical address of TDM registers
	u32 pdmac_base;				// Base physical address of DMAC registers
	u32 tdm_err_intr;			// TDM error interrupt
	u32 dmac_err_intr;			// DMAC error interrupt
	u32 dmac_done_intr;			// DMAC completion interrupt
	wait_queue_head_t wr_wakeup_event;	// Wakes up write polling
	wait_queue_head_t rd_wakeup_event;	// Wakes up read polling
	struct device *device;
	spinlock_t tdmlock;			// Locking of registers and this structure
	struct tdm_shared *txshared;		// Tx structure mapped to userspace
	struct tdm_shared *rxshared;		// Rx structure mapped to userspace
	u32 txsdno;				// Last descriptor number serviced
	struct file *freader;			// File struct used for input
	struct file *fwriter;			// File struct used for output
	struct proc_dir_entry *ftdm_dir;
	struct proc_dir_entry *fregs;
	struct proc_dir_entry *frxring;
	struct proc_dir_entry *ftxring;
	struct proc_dir_entry *frxshared;
	struct proc_dir_entry *ftxshared;
	struct proc_dir_entry *fstats;
	struct {
		u64 tx_bytes;
		u32 tx_bps;
		u32 tx_fifo_under_err;
		u32 tx_sync_err;
		u64 rx_bytes;
		u32 rx_bps;
		u32 rx_fifo_over_err;
		u32 rx_sync_err;
		u32 dmac_err;
		unsigned long last_sample;	// Timestamp (jiffies) of last stat update
		u64 last_tx_bytes;
		u64 last_rx_bytes;
	} stats;
};

#define TDM_ENABLE_TIMEOUT 1000	/* time out for TDM rx, tx enable */

// Provides initalization parameters for the device
// Statically defined in tdm_platform.h
struct device_audio_params
{
	u32 rir;
	u32 tir;
	u32 rfp;
	u32 tfp;
	u32 rcen[4];
	u32 tcen[4];
	u32 tcma[4];

	u32 dmac_irq;
	u32 tdm_irq;
	u32 dmac_err_irq;

	u32 rx_descrs;
	u32 rx_buflen_min;
	u32 rx_buflen_max;
	u32 rx_buflen_default;
	u32 rx_stridelen;
	u32 rx_framelen;

	u32 tx_descrs;
	u32 tx_buflen_min;
	u32 tx_buflen_max;
	u32 tx_buflen_default;
	u32 tx_stridelen;
	u32 tx_framelen;

	u8 tx_zerotemplate[ZEROPAT_SIZE];
};

#endif

