#ifndef _MMA8453_H
#define _MMA8453_H

#define MMA8453Q_STATUS                         0x00
#define MMA8453Q_STATUS_ZYXOW                   0x80
#define MMA8453Q_STATUS_ZOW                     0x40
#define MMA8453Q_STATUS_YOW                     0x20
#define MMA8453Q_STATUS_XOW                     0x10
#define MMA8453Q_STATUS_ZYXDR                   0x08
#define MMA8453Q_STATUS_ZDR                     0x04
#define MMA8453Q_STATUS_YDR                     0x02
#define MMA8453Q_STATUS_XDR                     0x01
#define MMA8453Q_OUT_X_MSB                      0x01
#define MMA8453Q_OUT_X_LSB                      0x02
#define MMA8453Q_OUT_Y_MSB                      0x03
#define MMA8453Q_OUT_Y_LSB                      0x04
#define MMA8453Q_OUT_Z_MSB                      0x05
#define MMA8453Q_OUT_Z_LSB                      0x06
#define MMA8453Q_SYSMOD                         0x0b
#define MMA8453Q_SYSMOD_SYSMOD1                 0x02
#define MMA8453Q_SYSMOD_SYSMOD0                 0x01
#define MMA8453Q_INT_SOURCE                     0x0c
#define MMA8453Q_INT_SOURCE_SRC_ASLP            0x80
#define MMA8453Q_INT_SOURCE_SRC_TRANS           0x20
#define MMA8453Q_INT_SOURCE_SRC_LNDPRT          0x10
#define MMA8453Q_INT_SOURCE_SRC_PULSE           0x08
#define MMA8453Q_INT_SOURCE_SRC_FF_MT           0x04
#define MMA8453Q_INT_SOURCE_SRC_DRDY            0x01
#define MMA8453Q_WHO_AM_I                       0x0d
#define MMA8453Q_WHO_AM_I_ID                    0x3a
#define MMA8453Q_XYZ_DATA_CFG                   0x0e
#define MMA8453Q_XYZ_DATA_CFG_FS_MASK           0x03
#define MMA8453Q_HP_FILTER_CUTOFF               0x0f
#define MMA8453Q_HP_FILTER_CUTOFF_PULSE_HPF_BYP 0x02
#define MMA8453Q_HP_FILTER_CUTOFF_PULSE_LPF_EN  0x01
#define MMA8453Q_HP_FILTER_CUTOFF_SEL_MASK      0x03
#define MMA8453Q_PL_STATUS                      0x10
#define MMA8453Q_PL_STATUS_NEWLP                0x80
#define MMA8453Q_PL_STATUS_LO                   0x40
#define MMA8453Q_PL_STATUS_LAPO_MASK            0x06
#define MMA8453Q_PL_STATUS_BAFRO                0x01
#define MMA8453Q_PL_CFG                         0x11
#define MMA8453Q_PL_CFG_DBCNTM                  0x80
#define MMA8453Q_PL_CFG_PL_EN                   0x40
#define MMA8453Q_PL_COUNT                       0x12
#define MMA8453Q_PL_BF_ZCOMP                    0x13
#define MMA8453Q_PL_BF_ZCOMP_BKFR_MASK          0xc0
#define MMA8453Q_PL_BF_ZCOMP_ZLOCK_MASK         0x07
#define MMA8453Q_P_L_THIS_REG                   0x14
#define MMA8453Q_P_L_THIS_REG_P_L_HTS_MASK      0xf8
#define MMA8453Q_P_L_THIS_REG_HYS_MASK          0x07
#define MMA8453Q_FF_MT_CFG                      0x15
#define MMA8453Q_FF_MT_CFG_ELE                  0x80
#define MMA8453Q_FF_MT_CFG_OAE                  0x40
#define MMA8453Q_FF_MT_CFG_ZEFE                 0x20
#define MMA8453Q_FF_MT_CFG_YEFE                 0x10
#define MMA8453Q_FF_MT_CFG_XEFE                 0x08
#define MMA8453Q_FF_MT_SRC                      0x16
#define MMA8453Q_FF_MT_SRC_EA                   0x80
#define MMA8453Q_FF_MT_SRC_ZHE                  0x20
#define MMA8453Q_FF_MT_SRC_ZHP                  0x10
#define MMA8453Q_FF_MT_SRC_YHE                  0x08
#define MMA8453Q_FF_MT_SRC_YHP                  0x04
#define MMA8453Q_FF_MT_SRC_XHE                  0x02
#define MMA8453Q_FF_MT_SRC_XHP                  0x01
#define MMA8453Q_FF_MT_THS                      0x17
#define MMA8453Q_FF_MT_THS_DBCNTM               0x80
#define MMA8453Q_FF_MT_THS_THS_MASK             0x7f
#define MMA8453Q_FF_MT_COUNT                    0x18
#define MMA8453Q_TRANSIENT_CFG                  0x1d
#define MMA8453Q_TRANSIENT_CFG_ELE              0x10
#define MMA8453Q_TRANSIENT_CFG_ZTEFE            0x08
#define MMA8453Q_TRANSIENT_CFG_YTEFE            0x04
#define MMA8453Q_TRANSIENT_CFG_XTEFE            0x02
#define MMA8453Q_TRANSIENT_CFG_HPF_BYP          0x01
#define MMA8453Q_TRANSIENT_SRC                  0x1e
#define MMA8453Q_TRANSIENT_SRC_EA               0x40
#define MMA8453Q_TRANSIENT_SRC_ZTRANSE          0x20
#define MMA8453Q_TRANSIENT_SRC_Z_TRANS_POL      0x10
#define MMA8453Q_TRANSIENT_SRC_YTRANSE          0x08
#define MMA8453Q_TRANSIENT_SRC_Y_TRANS_POL      0x04
#define MMA8453Q_TRANSIENT_SRC_XTRANSE          0x02
#define MMA8453Q_TRANSIENT_SRC_X_TRANS_POL      0x01
#define MMA8453Q_TRANSIENT_THS                  0x1f
#define MMA8453Q_TRANSIENT_THS_DBCNTM           0x80
#define MMA8453Q_TRANSIENT_THS_THS_MASK         0x7f
#define MMA8453Q_TRANSIENT_COUNT                0x20
#define MMA8453Q_PULSE_CFG                      0x21
#define MMA8453Q_PULSE_CFG_DPA                  0x80
#define MMA8453Q_PULSE_CFG_ELE                  0x40
#define MMA8453Q_PULSE_CFG_ZDPEFE               0x20
#define MMA8453Q_PULSE_CFG_ZSPEFE               0x10
#define MMA8453Q_PULSE_CFG_YDPEFE               0x08
#define MMA8453Q_PULSE_CFG_YSPEFE               0x04
#define MMA8453Q_PULSE_CFG_XDPEFE               0x02
#define MMA8453Q_PULSE_CFG_XSPEFE               0x01
#define MMA8453Q_PULSE_SRC                      0x22
#define MMA8453Q_PULSE_SRC_EA                   0x80
#define MMA8453Q_PULSE_SRC_AXZ                  0x40
#define MMA8453Q_PULSE_SRC_AXY                  0x20
#define MMA8453Q_PULSE_SRC_AXX                  0x10
#define MMA8453Q_PULSE_SRC_DPE                  0x08
#define MMA8453Q_PULSE_SRC_POLZ                 0x04
#define MMA8453Q_PULSE_SRC_POLY                 0x02
#define MMA8453Q_PULSE_SRC_POLX                 0x01
#define MMA8453Q_PULSE_THSX                     0x23
#define MMA8453Q_PULSE_THSY                     0x24
#define MMA8453Q_PULSE_THSZ                     0x25
#define MMA8453Q_PULSE_TMLT                     0x26
#define MMA8453Q_PULSE_LTCY                     0x27
#define MMA8453Q_PULSE_WIND                     0x28
#define MMA8453Q_ASLP_COUNT                     0x29
#define MMA8453Q_CTRL_REG1                      0x2a
#define MMA8453Q_CTRL_REG1_ASLP_RATE_MASK       0xc0
#define MMA8453Q_CTRL_REG1_DR_MASK              0x38
#define MMA8453Q_CTRL_REG1_DR_SHFT              3
#define MMA8453Q_CTRL_REG1_LNOISE               0x04
#define MMA8453Q_CTRL_REG1_F_READ               0x02
#define MMA8453Q_CTRL_REG1_ACTIVE               0x01
#define MMA8453Q_CTRL_REG2                      0x2b
#define MMA8453Q_CTRL_REG2_ST                   0x80
#define MMA8453Q_CTRL_REG2_RST                  0x40
#define MMA8453Q_CTRL_REG2_SMODS_MASK           0x18
#define MMA8453Q_CTRL_REG2_SLPE                 0x04
#define MMA8453Q_CTRL_REG2_MODS_MASK            0x03
#define MMA8453Q_CTRL_REG3                      0x2c
#define MMA8453Q_CTRL_REG3_WAKE_TRANS           0x40
#define MMA8453Q_CTRL_REG3_WAKE_LNDPRT          0x20
#define MMA8453Q_CTRL_REG3_WAKE_PULSE           0x10
#define MMA8453Q_CTRL_REG3_WAKE_FF_MT           0x08
#define MMA8453Q_CTRL_REG3_IPOL                 0x02
#define MMA8453Q_CTRL_REG3_PP_OD                0x01
#define MMA8453Q_CTRL_REG4                      0x2d
#define MMA8453Q_CTRL_REG4_INT_EN_ASLP          0x80
#define MMA8453Q_CTRL_REG4_INT_EN_TRANS         0x20
#define MMA8453Q_CTRL_REG4_INT_EN_LNDPRT        0x10
#define MMA8453Q_CTRL_REG4_INT_EN_PULSE         0x08
#define MMA8453Q_CTRL_REG4_INT_EN_FF_MT         0x04
#define MMA8453Q_CTRL_REG4_INT_EN_DRDY          0x01
#define MMA8453Q_CTRL_REG5                      0x2e
#define MMA8453Q_CTRL_REG5_INT_CFG_ASLP         0x80
#define MMA8453Q_CTRL_REG5_INT_CFG_TRANS        0x20
#define MMA8453Q_CTRL_REG5_INT_CFG_LNDPRT       0x10
#define MMA8453Q_CTRL_REG5_INT_CFG_PULSE        0x08
#define MMA8453Q_CTRL_REG5_INT_CFG_FF_MT        0x04
#define MMA8453Q_CTRL_REG5_INT_CFG_DRDY         0x01
#define MMA8453Q_OFF_X                          0x2f
#define MMA8453Q_OFF_Y                          0x30
#define MMA8453Q_OFF_Z                          0x31

struct accel_data {
	int16_t x, y, z;
};

enum ORIENT_TYPE {
    ORIENT_DETECT,
    ORIENT_TABLE,
    ORIENT_WALL_ABOVE,
    ORIENT_WALL_BELOW,
    ORIENT_NUM
};

extern int mma8453q_get_raw_accel(struct accel_data *ad);
extern void orient_init(void);
extern void orient_exit(void);
#endif
