#ifndef LIMELIGHT_FPGA_H
#define LIMELIGHT_FPGA_H

#include "sonos-ctl.h"
#include "hwevent_queue_user_api.h"
#include "button_event.h"


#define LIMELIGHT_VOL_UP_BIT  4
#define LIMELIGHT_MUTE_BIT	1
#define LIMELIGHT_VOL_DWN_BIT 0

#define LIMELIGHT_FPGA_BUTTON_ADDRESS	0x20
#define LIMELIGHT_MUTE_MASK    (1 << LIMELIGHT_MUTE_BIT)
#define LIMELIGHT_VOL_DWN_MASK (1 << LIMELIGHT_VOL_DWN_BIT)
#define LIMELIGHT_VOL_UP_MASK  (1 << LIMELIGHT_VOL_UP_BIT)
#define LIMELIGHT_BUTTONS_MASK \
        (LIMELIGHT_MUTE_MASK | LIMELIGHT_VOL_DWN_MASK | LIMELIGHT_VOL_UP_MASK)

#define LIMELIGHT_LED_AUTO_BIT     6
#define LIMELIGHT_LED_IR_FRONT_BIT 5
#define LIMELIGHT_LED_IR_TOP_BIT   4
#define LIMELIGHT_LED_WHITE_BIT    3
#define LIMELIGHT_LED_RED_BIT      2
#define LIMELIGHT_LED_GREEN_BIT    1
#define LIMELIGHT_LED_AMBER_BIT    0

#define LIMELIGHT_LED_AUTO_MASK      (1 << LIMELIGHT_LED_AUTO_BIT)
#define LIMELIGHT_LED_IR_FRONT_MASK  (1 << LIMELIGHT_LED_IR_FRONT_BIT)
#define LIMELIGHT_LED_IR_TOP_MASK    (1 << LIMELIGHT_LED_IR_TOP_BIT)
#define LIMELIGHT_LED_AMBER_MASK     (1 << LIMELIGHT_LED_AMBER_BIT)
#define LIMELIGHT_LED_RED_MASK       (1 << LIMELIGHT_LED_RED_BIT)
#define LIMELIGHT_LED_GREEN_MASK     (1 << LIMELIGHT_LED_GREEN_BIT)
#define LIMELIGHT_LED_WHITE_MASK     (1 << LIMELIGHT_LED_WHITE_BIT)
#define LIMELIGHT_LEDS_MASK          (LIMELIGHT_LED_AMBER_MASK | LIMELIGHT_LED_RED_MASK | \
                                      LIMELIGHT_LED_WHITE_MASK | LIMELIGHT_LED_GREEN_MASK)

#define FPGA_INTERRUPT_SPDIF_BLOCK_ERROR_MASK    0x20
#define FPGA_INTERRUPT_SPDIF_PARITY_ERROR_MASK   0x10
#define FPGA_INTERRUPT_SPDIF_RATE_CHANGE_MASK    0x08
#define FPGA_INTERRUPT_BUTTON_MASK               0x04
#define FPGA_INTERRUPT_SPDIF_LOCK_MASK           0x02
#define FPGA_INTERRUPT_IR_MASK                   0x01

#define FPGA_SPDIF_MIN_PULSE_32K     0x80
#define FPGA_SPDIF_MIN_PULSE_44K     0x60
#define FPGA_SPDIF_MIN_PULSE_48K     0x50
#define FPGA_SPDIF_MIN_PULSE_88K     0x30
#define FPGA_SPDIF_MIN_PULSE_96K     0x20

#define LIMELIGHT_AUDIO_RESET_BIT  7

#define LIMELIGHT_AUDIO_RESET_MASK  (1 << (31 - LIMELIGHT_AUDIO_RESET_BIT))

#define FPGA_REG_AUDIO_CNTLSTAT_SPDIF_LOCK          0x80
#define FPGA_REG_AUDIO_CNTLSTAT_SPDIF_RATE_CHANGE   0x10
#define FPGA_REG_AUDIO_CNTLSTAT_AMP_RESET           0x08
#define FPGA_REG_AUDIO_CNTLSTAT_AMP_HIZ             0x04
#define FPGA_REG_AUDIO_CNTLSTAT_AMP_POWER           0x02

#define FPGA_IRSELECT_IRTX_LEFT        0x01
#define FPGA_IRSELECT_IRTX_RIGHT       0x02
#define FPGA_IRSELECT_IRRX             0x04

#define FPGA_WR_BIT  0x01

#define FPGA_REG_VERSION                0x00
#define FPGA_REG_CHIPID                 0x01
#define FPGA_REG_TEST                   0x02
#define FPGA_REG_I2C                    0x03
#define FPGA_REG_IR_ASSERT_TIME_MSB     0x04
#define FPGA_REG_IR_ASSERT_TIME_LSB     0x05
#define FPGA_REG_IR_COUNT               0x06
#define FPGA_REG_IR_TIMEOUT_CONFIG_MSB  0x07
#define FPGA_REG_IR_TIMEOUT_CONFIG_LSB  0x08
#define FPGA_REG_IR_MIN_CONFIG          0x09
#define FPGA_REG_IR_MAX_CONFIG          0x0A
#define FPGA_REG_IR_RESOLUTION_CONFIG   0x0B
#define FPGA_REG_IR_SELECT              0x0C
#define FPGA_REG_IR_MEMORY              0x10
#define FPGA_REG_BUTTONS                0x20
#define FPGA_REG_LEDS                   0x21
#define FPGA_REG_LED_PWM                0x22
#define FPGA_REG_SPDIF_MIN_PULSE        0x23
#define FPGA_REG_AUDIO_CNTLSTAT         0x24
#define FPGA_REG_INTERRUPT_STATUS       0x28
#define FPGA_REG_INTERRUPT_MASK         0x29
#define FPGA_REG_AUDIO_STATUS_STICKY    0x2C
#define FPGA_REG_IR_LED_PWM             0x2B
#define FPGA_REG_LAST                   0x30
#endif

#define FPGA_GET_CHIP_SELECT(id) (id-1)

extern void fpga_init(struct button_event_queue *beq);
extern void fpga_SetLeds(unsigned long ledMask);
extern void fpga_SetLedPwm(unsigned long);
extern button_evt fpga_GetKeys(void);
extern int fpga_ReadRegCmd(unsigned long *regdata);
extern int fpga_WriteRegCmd(unsigned long *regdata);
extern int fpga_WriteReg(int reg, u8 value);
extern int fpga_ReadReg(int reg, u8 *data, unsigned int len);
extern int fpga_HandleInterrupt(void);
extern void fpga_PostDebounceEvents(void);
extern void fpga_ClearIr(void);
extern void fpga_GetIrData(struct syslib_irdata *pIrData, unsigned int userBufferSize,
                                    void (* copyFunc)(char *dest, char *src, unsigned int num));
extern int fpga_GetIrTimeout(unsigned long *param);
extern int fpga_SetIrTimeout(unsigned long *param);
extern int fpga_GetIrResolution(unsigned long *param);
extern int fpga_SetIrResolution(unsigned long *param);
extern unsigned long fpga_GetSpdifMinPulse(void);
extern int fpga_AmpReset(int assert);
extern int fpga_AmpHiZ(int hiz);
extern int fpga_AmpPower(int power);
extern void fpga_RemoveProcFiles(void);
extern int  fpga_SelectI2cChip(int inst);
extern void fpga_ReleaseI2cChip(int inst);
extern void fpga_FlushIrData(void);
extern void fpga_EnableIr(int);
extern void fpga_SetLedPulsate(int whitePulsateOn, int greenPulsateOn);
extern void fpga_SetIrLed(int on, u8 bit);
extern int fpga_IrRepeater(int enable);
extern int fpga_IrRxSelect(int top);
extern int fpga_get_ir_runt_threshold(unsigned long *param);
extern int fpga_set_ir_runt_threshold(unsigned long param);
extern int fpga_set_ir_led_brightness(unsigned long param);
extern void fpga_get_state(enum HWEVTQ_EventInfo *play_pause, enum HWEVTQ_EventInfo *vol_up, enum HWEVTQ_EventInfo *vol_down, enum HWEVTQ_EventInfo *ir);
extern void fpga_set_repeat_time(unsigned int repeat_time);
extern unsigned int fpga_get_repeat_time(void);
extern void audioctl_updateIrSelect(void);

static inline void fpga_TurnOnIrLed(u8 bit)
{
   fpga_SetIrLed(1, bit);
}
static inline void fpga_ShutOffIrLed(u8 bit)
{
   fpga_SetIrLed(0, bit);
}
static inline void fpga_RemoveAmpReset(void)
{
   fpga_AmpReset(0);
}
static inline void fpga_AssertAmpReset(void)
{
   fpga_AmpReset(1);
}
static inline void fpga_RemoveAmpHiZ(void)
{
   fpga_AmpHiZ(0);
}
static inline void fpga_AssertAmpHiZ(void)
{
   fpga_AmpHiZ(1);
}
static inline void fpga_DisableAmpPower(void)
{
   fpga_AmpPower(0);
}
static inline void fpga_EnableAmpPower(void)
{
   fpga_AmpPower(1);
}
static inline void fpga_SelectTopIrReceiver(void)
{
	fpga_IrRxSelect(1);
}
static inline void fpga_SelectFrontIrReceiver(void)
{
	fpga_IrRxSelect(0);
}

int register_ir_rcv_callback(void (*ir_callback)(u8 *data, unsigned int bytes));
int unregister_ir_rcv_callback(void);
