#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <string.h>

struct led_func {
	char led_slot[8];
	int  led_flags;
};
#define AUDIODEV_R8OP_LED_FUNC_RESTART		0x00000001

#define LED_DEVICE "/dev/audioctl"

#define LED_WHITE	 			1
#define LED_GREEN	 			2
#define LED_AMBER		 		4
#define LED_RED				8
#define LED_GREEN_BUTTON	0x10
#define LED_OVERRIDE			0x20

#define AUDIOCTL_R8OP_LED_REQUEST     _IOW(252, 144, int)
#define AUDIOCTL_R8OP_LED_FUNC        _IOW(252, 156, struct led_func)
#define AUDIOCTL_R8OP_SET_LED_PWM     _IOW(252, 147, int)
#define AUDIOCTL_IR_REPEATER		     _IOW(252, 26, int)
#define AUDIOCTL_IR_DECODE_NOTIFY	  _IO(252, 27)

int main(int argc, char **argv)
{
   int fd;
   int ret;
   int i,j;
   char *arg;
   struct led_func func;

   printf("Testing the amazing Limelight LED driver\n\n");

   if (argc == 1) {
      printf("Shutting all LEDs off\n");
      for (i = 0; i < 8; i++) {
         func.led_slot[i] = 0;
      }
      func.led_flags = 0;

      fd = open(LED_DEVICE, O_RDONLY);
      if (fd < 0) {
         printf("error opening device %s error %d\n", LED_DEVICE, fd);
         exit(0);
      }
      printf("file open\n");
      ret = ioctl(fd, AUDIOCTL_R8OP_LED_FUNC, &func);
      if (ret == -1)
         printf("ERROR: ioctl\n");
      else
         printf("Success\n");
      exit(0);
   }

   if (argc == 3) {
      fd = open(LED_DEVICE, O_RDONLY);
      if (fd < 0) {
         printf("error opening device %s error %d\n", LED_DEVICE, fd);
         exit(0);
      }
      if (strcmp(argv[1], "irled") == 0) {
         int codes;
         if (strcmp(argv[2], "blink") == 0) {
            codes = 1;
         }
         else {
            codes = 100;
         }
         for (i = 0; i < codes; i++) {
            ret = ioctl(fd, AUDIOCTL_IR_DECODE_NOTIFY, NULL);
            usleep(100 * 1000);
         }
         printf("IR-decode ioctl sent\n");
      }
      else if (strcmp(argv[1], "ir-repeat") == 0) {
         int on=0;
         if (strcmp(argv[2], "on") == 0) {
            on = 1;
         }
         ret = ioctl(fd, AUDIOCTL_IR_REPEATER, &on);
      }
      if (ret == -1)
         printf("ERROR: ioctl\n");
      else
         printf("Success\n");
      exit(0);      
   }
   if (argc == 2) {
      int dutyCycle=20042007;

      dutyCycle = atoi(argv[1]);
      if ((dutyCycle >= 0) && (dutyCycle <= 256)) {
         fd = open(LED_DEVICE, O_RDONLY);
         if (fd < 0) {
            printf("error opening device %s\n", LED_DEVICE);
            exit(0);
         }
         printf("Setting white LED duty cycle to %d\n", dutyCycle);
         ret = ioctl(fd, AUDIOCTL_R8OP_SET_LED_PWM, &dutyCycle);
         if (ret == -1)
            printf("ERROR: ioctl\n");
         else
            printf("Success\n");
      }
      else printf("illegal duty cycle %d\n", dutyCycle);
      exit(0);
   }

   if (argc == 3) {
      int ledmask = LED_OVERRIDE;
      if (strcmp(argv[1], "o") != 0) {
         printf("expected override option, abort\n");
         exit(0);
      }
      if (strchr(argv[2], 'r'))
         ledmask |= LED_RED;
      if (strchr(argv[2], 'w'))
         ledmask |= LED_WHITE;
      if (strchr(argv[2], 'a'))
         ledmask |= LED_AMBER;
      if (strchr(argv[2], 'g'))
         ledmask |= LED_GREEN;
      if (strchr(argv[2], 'b'))
         ledmask |= LED_GREEN_BUTTON;
      if (strchr(argv[2], 'o'))
         ledmask = 0;

      fd = open(LED_DEVICE, O_RDONLY);
      if (fd < 0) {
         printf("error opening device %s error %d\n", LED_DEVICE, fd);
         exit(0);
      }
      printf("Setting LED mask\n");
      ret = ioctl(fd, AUDIOCTL_R8OP_LED_REQUEST, &ledmask);
      if (ret == -1)
         printf("ERROR: ioctl\n");
      else
         printf("Success\n");
      exit(0);
   }

   if (argc != 9) {
      printf("  only %d args, 8 required\n", argc-1);
      exit(0);
   }

   fd = open(LED_DEVICE, O_RDONLY);
   if (fd < 0) {
      printf("error opening device %s\n", LED_DEVICE);
      exit(0);
   }
   printf("File %s is now open\n\n", LED_DEVICE);

   func.led_flags = 0;
   for (i = 0; i < 8; i++) {
      func.led_slot[i] = 0;
      j = 0;
      arg = argv[i+1];
      while (arg[j] != '\0') {
         if (arg[j] == 'R')
            func.led_flags |= AUDIODEV_R8OP_LED_FUNC_RESTART;
         if (arg[j] == 'w')
            func.led_slot[i] |= LED_WHITE;
         if (arg[j] == 'r')
            func.led_slot[i] |= LED_RED;
         if (arg[j] == 'a')
            func.led_slot[i] |= LED_AMBER;
         if (arg[j] == 'g')
            func.led_slot[i] |= LED_GREEN;
         if (arg[j] == 'b')
            func.led_slot[i] |= LED_GREEN_BUTTON;
         j++;
      }
   }

   for (i = 0; i < 8; i++)
      printf("%d: %02x\n", i, func.led_slot[i]);

   ret = ioctl(fd, AUDIOCTL_R8OP_LED_FUNC, &func);
   if (ret == -1)
      printf("ERROR: ioctl\n");
   else
      printf("Success\n");
}
