#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include "audioctl_pub.h"
#include "errno.h"

extern int errno;

#define FPGA_DEVICE "/dev/audioctl"

typedef struct audiodev_irdata
{
   unsigned int bufferSize;
   unsigned int bytesRead;
   char         buffer[1];
} audiodev_irdata_t;
#define AUDIODEV_IRDATA_SIZE(n) (sizeof(audiodev_irdata_t) + n - 1) 

#define AUDIOCTL_GET_IR_DATA 	         _IOWR(252, 13, char[256])
#define AUDIOCTL_GET_IR_TIMEOUT			_IOR(AUDIOCTL_MAJOR, 14, int)
#define AUDIOCTL_GET_IR_RESOLUTION		_IOR(AUDIOCTL_MAJOR, 15, int)
#define AUDIOCTL_FLUSH_IR  				_IO(AUDIOCTL_MAJOR,  16)
#define AUDIOCTL_SET_IR_TIMEOUT			_IOW(AUDIOCTL_MAJOR, 17, int)
#define AUDIOCTL_SET_IR_RESOLUTION		_IOW(AUDIOCTL_MAJOR, 18, int)
#define AUDIOCTL_ENABLE_IR  				_IO(AUDIOCTL_MAJOR,  19)
#define AUDIOCTL_DISABLE_IR  				_IO(AUDIOCTL_MAJOR,  20)
#define AUDIOCTL_GET_SPDIF_MIN_PULSE	_IOR(AUDIOCTL_MAJOR, 23, int)
#define AUDIOCTL_R8OP_KEYPAD_READ      _IOR(AUDIOCTL_MAJOR, 132, int)
#define AUDIOCTL_IR_DECODE_NOTIFY	   _IO(AUDIOCTL_MAJOR, 27)
#define AUDIODEV_CTL_GET_IR_RUNT_THRESHOLD _IOR(AUDIOCTL_MAJOR, 32, int)
#define AUDIODEV_CTL_SET_IR_RUNT_THRESHOLD _IOW(AUDIOCTL_MAJOR, 33, int)

#pragma pack(1)
struct button_evt{
        char c;
        short distance;
};
#pragma pack()
static struct button_evt evt;

int main(int argc, char **argv)
{
   int fd;
   int res, i, butt, ret;
   int readfails=0;
   unsigned int irBytes;
   char buttons;
   audiodev_irdata_t *irdata;
   char buffer[300];
   int timeout, resolution, pulse, runt;

   printf("argc %d\n", argc);

   fd = open(FPGA_DEVICE, O_RDONLY);
   if (fd < 0) {
      perror("Error string ");
      printf("error (%d, errno %d) opening device %s\n", fd, errno, FPGA_DEVICE);
      exit(0);
   }

   if (argc > 1) {
      int et, er;
      int wr=0;

      if (strcmp(argv[1], "ir-disable") == 0) {
         res = ioctl(fd, AUDIOCTL_DISABLE_IR, NULL);
         if (res < 0) {
            printf("IR disable ioctl error %d\n", res);
         }
         else {
            printf("IR disabled\n");
         }
         exit(0);
      }

      if (strncmp(argv[1], "-w", 2) == 0) {
         wr = 1;
      }

      if (wr) {
         if (strncmp(argv[2], "timeout", 1) == 0) {
            timeout = strtol(argv[3], NULL, 10);
            et = ioctl(fd, AUDIOCTL_SET_IR_TIMEOUT, &timeout);
            if (et == 0) 
               printf("Timeout: %u usec\n", timeout);
            else
            printf("set timeout ioctl error %d\n", et);
         }
         else if (strncmp(argv[2], "resolution", 9) == 0) {
            resolution = strtol(argv[3], NULL, 10);
            er = ioctl(fd, AUDIOCTL_SET_IR_RESOLUTION, &resolution);
            if (er == 0) 
               printf("Resolution: %u nsec\n", resolution);
            else
               printf("set resolution ioctl error %d\n", er);    
         }
         else if (strncmp(argv[2], "runt", 4) == 0) {
            runt = strtol(argv[3], NULL, 10);
            er = ioctl(fd, AUDIODEV_CTL_SET_IR_RUNT_THRESHOLD, &runt);
            if (er == 0) 
               printf("Runt size: %u bytes\n", runt);
            else
               printf("set runt size ioctl error %d\n", er);    
         }
         else printf("unknown option %s\n", argv[1]);
      }
      else
      {
		  printf("RD %s\n", argv[2]);
         if (strncmp(argv[2], "timeout", 1) == 0) {
            et = ioctl(fd, AUDIOCTL_GET_IR_TIMEOUT, &timeout);
            if (et == 0) 
               printf("Timeout: %u usec\n", timeout);
            else
            printf("get timeout ioctl error %d\n", et);
         }
         else if (strncmp(argv[2], "resolution", 9) == 0) {
            er = ioctl(fd, AUDIOCTL_GET_IR_RESOLUTION, &resolution);
            if (er == 0) 
               printf("Resolution: %u nsec\n", resolution);
            else
               printf("get resolution ioctl error %d\n", er);    
         }
         else if (strncmp(argv[2], "runt", 4) == 0) {
            er = ioctl(fd, AUDIODEV_CTL_GET_IR_RUNT_THRESHOLD, &runt);
            if (er == 0) 
               printf("Runt size: %u bytes\n", runt);
            else
               printf("get runt size ioctl error %d\n", er);    
         }
         else if (strncmp(argv[2], "pulse", 5) == 0) {
            er = ioctl(fd, AUDIOCTL_GET_SPDIF_MIN_PULSE, &pulse);
            if (er == 0) 
               printf("SPDIF min pulse: %u HZ\n", pulse);
            else
               printf("get pulse ioctl error %d\n", er);    
         }
      }
      exit(0);
   }

   printf("Entering IR receive loop...\n");
   res = ioctl(fd, AUDIOCTL_R8OP_KEYPAD_READ, &butt);
   if (res < 0) {
      printf("abort, keypad read ioctl error\n");
      exit(0);
   }
   evt.c = butt & 0xff;

   res = ioctl(fd, AUDIOCTL_GET_IR_TIMEOUT, &timeout);
   if (res < 0) {
      printf("get timeout ioctl error %d\n", res);
      exit(0);
   }

   res = ioctl(fd, AUDIOCTL_GET_IR_RESOLUTION, &resolution);
   if (res < 0) {
      printf("get resolution ioctl error %d\n", res); 
      exit(0);
   }

   res = ioctl(fd, AUDIOCTL_FLUSH_IR, NULL);
   if (res < 0) {
      printf("abort, IR flush ioctl error %d\n", res);
      exit(0);
   }

   res = ioctl(fd, AUDIOCTL_ENABLE_IR, NULL);
   if (res < 0) {
      printf("abort, IR enable ioctl error %d\n", res);
      exit(0);
   }

   while(1) {
      buttons = evt.c;
      if (buttons & SW_IR_READY) {     
         irBytes = 1;
         while (irBytes > 0) {
            memset(buffer, 0, sizeof(buffer));
            irdata = (audiodev_irdata_t *)buffer;
            irdata->bufferSize = 256;
            res = ioctl(fd, AUDIOCTL_GET_IR_DATA, irdata);
            if (res < 0) {
               printf("\nERROR: ioctl %d\n", res);
               exit(0);
            }
            irBytes = irdata->bytesRead;
            if (irBytes > 0) {
                printf("\nIR Data\n");
                printf("bytesRead %d\n",irdata->bytesRead);
                printf("Resolution: %u nsec\n", resolution);
                printf("Timeout: %u usec\n", timeout);
               for (i = 0; i < irdata->bytesRead; i++) {
                   if( (i & 0x01) == 0x01 ){
                       printf("| %d\n", irdata->buffer[i]);

                   }
                   else{
                       printf("%d ", irdata->buffer[i]);
                   }

               }
			   ret = ioctl(fd, AUDIOCTL_IR_DECODE_NOTIFY, NULL);
			   if (ret < 0)
				   printf("IR notify error %d\n", ret);
               printf("\n");
            }
            else printf("all IR data read\n");
         }
      }
      else {
         printf("No IR data ready, other buttons (%x)\n", buttons);
      }
      res = read(fd, &evt, sizeof(evt));
      if (res != sizeof(evt)) {
          printf("Read: size error, got %d, expected %d\n", res, sizeof(evt));
          if (readfails++ > 4) exit(0);
      }
   }
}
