#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include "audioctl_pub.h"

#define FPGA_DEVICE "/dev/audioctl"

#define AUDIOCTL_GET_SPDIF_MIN_PULSE   _IOR(252,  23, int)
#define AUDIOCTL_FPGA_READ_REG         _IOWR(252, 24, int)
#define AUDIOCTL_FPGA_WRITE_REG        _IOWR(252, 25, int)

int main(int argc, char **argv)
{
   int fd;
   int res;
   char reg, data;
   int regdata;
   char *orient;

   fd = open(FPGA_DEVICE, O_RDONLY);
   if (fd < 0) {
      printf("error opening device %s\n", FPGA_DEVICE);
      exit(0);
   }

   if (strstr(argv[0], "read") != 0) {
      if (argc != 2) {
         printf("useage: %s reg-num\n", argv[0]);
         exit(0);
      }
      regdata = (int)strtol(argv[1], NULL, 16);
      res = ioctl(fd, AUDIOCTL_FPGA_READ_REG, &regdata);
      if (res < 0) 
         printf("ERROR: ioctl %d\n", res);
      else {
         printf("%02x\n", regdata);
      } 
   }
   else if (strstr(argv[0], "write") != NULL) {
      if (argc != 3) {
         printf("useage: %s reg-num data\n", argv[0]);
         exit(0);
      }
      reg  = (char)strtol(argv[1], NULL, 16);
      data = (char)strtol(argv[2], NULL, 16);
      regdata = (reg << 8) | data;
      res = ioctl(fd, AUDIOCTL_FPGA_WRITE_REG, &regdata);
      if (res < 0) 
         printf("ERROR: ioctl %d\n", res);
   }
   else if (argc == 1) {
      res = ioctl(fd, AUDIOCTL_GET_SPDIF_MIN_PULSE, &regdata);
      if (res < 0) 
         printf("ERROR: ioctl %d\n", res);
      else
         printf("SPDIF min pulse %d (0x%x)\n", regdata, regdata);
   }
   else {
      printf("unrecognized command\n");
   }
}
