/*
 * Copyright (c) 2011-2021 Sonos Inc.
 * All rights reserved.
 */
#undef RRTEST

#include <generated/autoconf.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <linux/watchdog.h>
#include <linux/semaphore.h>
#include <linux/proc_fs.h>
#include "mdp.h"

#include "audioctl_pub.h"
#include "audioctl.h"


extern struct file_operations dsp_fops;
extern struct file_operations dsp_mem_fops;
extern struct file_operations i2c_fops;
extern struct file_operations audioctl_fops;

extern void dsp_intr(void);
extern int  dsp_proc_init(void);
extern int  dsp_device_init(void);

extern int i2c_proc_init(void);
extern int i2c_device_init(void);

extern int audioctl_proc_init(void);
extern int audioctl_device_init(void);
extern int audioctl_device_cleanup(void);
extern void audioctl_proc_remove(void);

extern unsigned fenway_gpio_get_keys(void);
extern void i2c_initFenwayDevices(void);

void cleanup_module( void );

int pwm_InitVcxo(void);
int pwm_InitBrightnessLedPwm(void);


#define AUDIOCTL_NAME "audioctl"

extern int fsl_8xxx_tdm_init(void);

extern struct manufacturing_data_page sys_mdp;

int
init_module( void )
{
   int ret = 0;

    printk("audiodev.ko: init_module %u/%u.\n", (int)sys_mdp.mdp_model, (int)sys_mdp.mdp_submodel);
    if (sys_mdp.mdp_model != MDP_MODEL_LIMELIGHT) {
       printk("Corrected MDP model from %x to %x\n", (int)sys_mdp.mdp_model, MDP_MODEL_LIMELIGHT);
       sys_mdp.mdp_model    = MDP_MODEL_LIMELIGHT;
       sys_mdp.mdp_submodel = MDP_SUBMODEL_LIMELIGHT;
       sys_mdp.mdp_region   = MDP_REGION_USCA;
    }

	audioctl_device_init();

    ret = register_chrdev(AUDIOCTL_MAJOR, AUDIOCTL_NAME, &audioctl_fops);
    if (ret) {
       printk("Error %d registering device %s\n", ret, AUDIOCTL_NAME);
	   return ( ret );
    }
    else {
       printk("Device %s successfully registered with major device number %d\n",
              AUDIOCTL_NAME, AUDIOCTL_MAJOR);
    }

    if( (ret = audioctl_proc_init()) ) {
       printk("audioctl_proc_init: early exit\n");
       return( ret );
    }

    fsl_8xxx_tdm_init();

#if 0
    i2c_initLimelightDevices();
    pwm_InitVcxo();
    pwm_InitBrightnessLedPwm();
    audioctl_device_init();
#endif

    return ret;
}

void
cleanup_module( void )
{
   i2c_shutdownLimelightDevices();

   audioctl_proc_remove();
   audioctl_device_cleanup();

   unregister_chrdev(AUDIOCTL_MAJOR, AUDIOCTL_NAME);
}

MODULE_LICENSE ("GPL");
MODULE_AUTHOR ("B. Tober");
MODULE_DESCRIPTION ("Limelight Audio Module.");
