#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include "audioctl_pub.h"
#include "sonos-ctl.h"

#define AUDIOCTL_R8OP_KEYPAD_READ _IOR(252, 132, int)

int readfails = 0;

void get_orient_string(button_evt bevent, char *str)
{
    button_evt orient = bevent & SW_POSITION_MASK;
    switch (orient) {
    case SW_POSITION_TABLE:
        strcpy(str, "Table");
        break;
    case SW_POSITION_WALL_ABOVE:
        strcpy(str, "WallAbove");
        break;
    case SW_POSITION_WALL_BELOW:
        strcpy(str, "WallBelow");
        break;
    default:
        sprintf(str, "UnknowOrientation-%08x\n", orient);
    }
}

int main()
{
   int fd;
   int res;
   button_evt butt, buttons, evt;
   char orient[40];

   printf("Testing the amazing Limelight button driver\n\n");

   fd = open(BUTTON_DEVICE, O_RDONLY);
   if (fd < 0) {
      printf("error opening device %s\n", BUTTON_DEVICE);
      exit(0);
   }
   printf("File %s is now open\n\n", BUTTON_DEVICE);

   butt = 0;
   res = ioctl(fd, AUDIOCTL_R8OP_KEYPAD_READ, &butt);
   if (res == -1) 
      printf("ERROR: ioctl\n");
   else {
      get_orient_string(butt, orient);
      printf("Success, current orientation %s\n", orient);
   } 

   printf("Waiting for buttons to be pressed\n\n");
      
   while(1) {
      res = read(fd, &evt, sizeof(evt));
      if (res != sizeof(evt)) {
          printf("Read: size error, got %d, expected %d\n", res, sizeof(evt));
          if (readfails++ > 4) exit(0);
          else continue;
      }
      buttons = ~evt;
      get_orient_string(evt, orient);
      printf("%08x-%08x: %s-%s-%s-%s-%s\n", buttons, evt,
             (buttons & SW_VOL_UP) ? "UP" : "up", 
             (buttons & SW_VOL_DWN) ? "DOWN" : "down",
             (buttons & SW_MUTE) ? "MUTE" : "mute",
             (evt & SW_IR_READY) ? "IR" : "ir",
			 orient
         );
   }
}
