/*
 * Copyright (c) 2011-2020 Sonos Inc.
 * All rights reserved.
 *
 * Local I2C audioctl definitions.
 */
#include <linux/i2c.h>
#include "hwevent_queue_user_api.h"
#include "button_event.h"

#define TAS5708_I2C_ADDRESS              0x1b
#define AMP_THERMAL_SENSOR_I2C_ADDRESS   0x4e
#define AMP_P1_THERMAL_SENSOR_I2C_ADDRESS   0x48
#define POWER_THERMAL_SENSOR_I2C_ADDRESS 0x48
#define CPU_THERMAL_SENSOR_I2C_ADDRESS   0x4e
#define ACCELEROMETER_I2C_ADDRESS        0x4c

#define I2C_WRITE_MAX_SIZE 32


typedef int immap_t;

extern void thermalsensor_InitDriver(struct i2c_adapter *pI2cAdapter0, struct i2c_adapter *pI2cAdapter1, struct button_event_queue *beq);
extern void thermalsensor_ExitDriver(void);
extern void thermalsensor_SetDebugTemp(char *name, long longtemp);
extern int  thermalSensor_PrintStatus(char *buf);
extern int  thermalSensor_GetTemperature(int tempSensorInst, int *pCelsiusTemp);
extern long thermalsensor_GetStatus(void);

extern int  mma7660_InitDriver(struct i2c_adapter *pI2cAdapter);
extern int  mma7660_ExitDriver(void);
extern enum HWEVTQ_EventInfo mma7660_GetOrient(void);
extern int mma7660_DumpRegs(char *pos);
extern int mma7660_PrintStatus(char *pos);
extern void mma7660_PollDevice(void);
extern char * mma7660_GetRawSamples(int *pNumSamples, long longaxis);
extern void mma7660_RestartOrientationSensing(void);

extern int mma8453q_init(struct i2c_adapter* pI2cAdapter);
extern void mma8453q_exit(void);
extern void mma8453_orient_poll(void);
extern int mma8453_print_status(char *buf);
extern enum HWEVTQ_EventInfo mma8453_get_orient(void);

extern int  tas5708_InitDriver(struct i2c_adapter *pI2cAdapter);
extern int  tas5708_ExitDriver(void);
extern int  tas5708_DumpRegs(char *pos);
extern int  tas5708_WriteReg(int ampId, int reg, char *data, unsigned int len);
extern int  tas5708_ReadReg(int ampId, int reg, char *data, unsigned int len);
extern long tas5708_ReadStatus(void);

extern void i2c_initLimelightDevices(struct button_event_queue *beq);
extern void i2c_shutdownLimelightDevices(void);
extern int  i2c_WriteReg(struct i2c_client *pClient, int regAddr, char *data, unsigned int len);
extern int  i2c_ReadReg(struct i2c_client *pClient, int regAddr, char *buf, unsigned int len);
extern void i2c_GetSem(void);
extern void i2c_ReleaseSem(void);
