/*
 * Copyright (c) 2020 Sonos Inc.
 * All rights reserved.
 */
#ifndef _REGDUMP_H
#define _REGDUMP_H

struct EnumInfo {
    const char * text;
    unsigned value;
};

struct RegInfo {
    const char * name;
    unsigned offset;
    unsigned size;
    int startBit;
    int endBit;
    const struct EnumInfo * enums;
};

int DumpMemory8(void __iomem * baseAddr, int size, char *buffer, int count);
int DumpMemory16(void __iomem * baseAddr, int size, char *buffer, int count);
int DumpMemory32(void __iomem * baseAddr, int size, char *buffer, int count);
int DumpRegisters(void __iomem * baseAddr, const struct RegInfo * descr, char *buffer, int count);

extern const struct EnumInfo eiOffOn[];
extern const struct EnumInfo eiOnOff[];
extern const struct EnumInfo eiDisableEnable[];
extern const struct EnumInfo eiEnableDisable[];
extern const struct EnumInfo eiFalseTrue[];

#endif
