/*
 * Copyright (c) 2004 Rincon Networks Inc.
 * All rights reserved.
 */

#ifndef _DSPDEV_H
#define _DSPDEV_H

#define DSPDEV_NAME         "dsp"
#define DSPDEV_MAJOR         250

#define DSP_SYS_NOP         0
#define DSP_SYS_ECHO            1
#define DSP_SYS_FLUSH           2
#define DSP_SYS_BSP1_CONFIG     4
#define DSP_SYS_BSP2_CONFIG     5
#define DSP_SYS_CONFIG          6
#define DSP_SYS_DATA_XFR_OPS    8
#define DSP_SYS_READY           9
#define DSP_SYS_GET_TOD         10
#define DSP_SYS_GET_BYTE_PTR    11
#define DSP_SYS_RESET           12
#define DSP_SYS_WOW_CONTROL     13
#define DSP_SYS_GET_CPU         14
#define DSP_SYS_FILTER_LEVEL    15
#define DSP_SYS_FILTER_ENABLE   16
#define DSP_SYS_HI_RES_DATA     17
#define DSP_SYS_SUBWOOFER_SOURCE 18
#define DSP_SYS_FLUSH_INPUT     20

#define DSP_SYS_GET_VOLUME      21
#define DSP_SYS_SET_VOLUME      22
#define DSP_SYS_GET_RVOLUME     23
#define DSP_SYS_SET_RVOLUME     24
#define DSP_SYS_SET_VOLUME_NO_RAMP  25
#define DSP_SYS_RESET_TX_ORUN   32
#define DSP_SYS_GET_TX_ORUN     33

#define DSP_SYS_RESET_RX_ORUN   34
#define DSP_SYS_GET_RX_ORUN     35

#define DSP_SYS_SET_PWM		36
#define DSP_SYS_GET_PWM		37

#define DSP_SYS_SET_NEXT_OUT    38
#define DSP_SYS_DRAIN		39

#define DSP_SYS_GET_TX_PARAMS	40
#define DSP_SYS_GET_RX_PARAMS	41


#define DSPDEV_ECHO             _IOW(DSPDEV_MAJOR, DSP_SYS_ECHO, int)
#define DSPDEV_FLUSH            _IO(DSPDEV_MAJOR,  DSP_SYS_FLUSH)
#define DSPDEV_BEGIN_DATA_XFER  _IO(DSPDEV_MAJOR,  DSP_SYS_DATA_XFR_OPS)
#define DSPDEV_GET_TOD          _IOR(DSPDEV_MAJOR, DSP_SYS_GET_TOD, long long)
#define DSPDEV_GET_BYTE_PTR     _IOR(DSPDEV_MAJOR, DSP_SYS_GET_BYTE_PTR, int )
#define DSPDEV_FILTER_LEVEL     _IOC(_IOC_WRITE,DSPDEV_MAJOR,(DSP_SYS_FILTER_LEVEL),12)
#define DSPDEV_FILTER_ENABLE    _IOC(_IOC_WRITE,DSPDEV_MAJOR,(DSP_SYS_FILTER_ENABLE),8)
#define DSPDEV_SUBWOOFER_SOURCE _IOW(DSPDEV_MAJOR, DSP_SYS_SUBWOOFER_SOURCE, int)
#define DSPDEV_FLUSH_INPUT      _IO(DSPDEV_MAJOR,  DSP_SYS_FLUSH_INPUT)
#define DSPDEV_GET_VOLUME       _IOR(DSPDEV_MAJOR, DSP_SYS_GET_VOLUME, int)
#define DSPDEV_SET_VOLUME       _IOW(DSPDEV_MAJOR, DSP_SYS_SET_VOLUME, int)
#define DSPDEV_GET_RVOLUME      _IOR(DSPDEV_MAJOR, DSP_SYS_GET_RVOLUME, int)
#define DSPDEV_SET_RVOLUME      _IOW(DSPDEV_MAJOR, DSP_SYS_SET_RVOLUME, int)
#define DSPDEV_SET_VOLUME_NO_RAMP _IOW(DSPDEV_MAJOR, DSP_SYS_SET_VOLUME_NO_RAMP, int)

#define DSPDEV_RESET_TX_ORUN    _IO(DSPDEV_MAJOR,  DSP_SYS_RESET_TX_ORUN)
#define DSPDEV_GET_TX_ORUN      _IOR(DSPDEV_MAJOR, DSP_SYS_GET_TX_ORUN, int)

#define DSPDEV_RESET_RX_ORUN    _IO(DSPDEV_MAJOR,  DSP_SYS_RESET_RX_ORUN)
#define DSPDEV_GET_RX_ORUN      _IOR(DSPDEV_MAJOR, DSP_SYS_GET_RX_ORUN, int)

#define DSPDEV_SET_PWM		_IOC(_IOC_WRITE,DSPDEV_MAJOR,(DSP_SYS_SET_PWM),8)
#define DSPDEV_GET_PWM		_IOC(_IOC_READ|_IOC_WRITE,DSPDEV_MAJOR,(DSP_SYS_GET_PWM),4)

#define DSPDEV_SET_NEXT_OUT    _IOW(DSPDEV_MAJOR, DSP_SYS_SET_NEXT_OUT, unsigned long long)
#define DSPDEV_DRAIN		_IO(DSPDEV_MAJOR, DSP_SYS_DRAIN)

struct dsp_params {
	unsigned int num_buffers;
	unsigned int frames_per_buffer;
	unsigned int channels_per_frame;
	unsigned int channel_len;
};
#define DSPDEV_GET_TX_PARAMS	_IOR(DSPDEV_MAJOR, DSP_SYS_GET_TX_PARAMS, struct dsp_params)
#define DSPDEV_GET_RX_PARAMS	_IOR(DSPDEV_MAJOR, DSP_SYS_GET_RX_PARAMS, struct dsp_params)

#endif
