/*
 * Copyright (c) 2020 Sonos, Inc.
 * All rights reserved.
 */
#ifndef _AUDIODEV_LOG_H
#define _AUDIODEV_LOG_H

#define MODULE_NAME  "AUDIODEV"

#define AUDIODEV_ERR(FMT, ARG...)           printk(KERN_ERR "["MODULE_NAME"]ERROR: "FMT, ## ARG)
#define AUDIODEV_WRN(FMT, ARG...)           printk(KERN_WARNING "["MODULE_NAME"]WARNING: "FMT, ## ARG)
#define AUDIODEV_INF(FMT, ARG...)           printk(KERN_INFO "["MODULE_NAME"]"FMT, ## ARG)
#define AUDIODEV_DBG(FMT, ARG...)           printk(KERN_DEBUG "["MODULE_NAME"] %s:%d: "FMT, __FUNCTION__, __LINE__, ## ARG)

#ifdef DEBUG_FUNCTIONS
#define LOG_FUNCTION_PARAM(PFMT, ARG...)    AUDIODEV_DBG("("PFMT")\n", ## ARG)
#define LOG_FUNCTION()                      AUDIODEV_DBG("()\n")
#define LOG_EXIT()                          AUDIODEV_DBG("return\n")
#define LOG_EXIT_INT(i)                     AUDIODEV_DBG("return(%d)\n", i)
#define LOG_EXIT_ERR(rc)                    AUDIODEV_DBG("return("#rc" = %d) : %s\n", rc, (rc >= 0) ? "SUCCESS" : "FAILED")
#define LOG_EXIT_RET(EFMT, ARG...)          AUDIODEV_DBG("return("EFMT")\n", ## ARG)
#else
#define LOG_FUNCTION_PARAM(FMT, ARG...)
#define LOG_FUNCTION()
#define LOG_EXIT()
#define LOG_EXIT_INT(i)
#define LOG_EXIT_ERR(rc)
#define LOG_EXIT_RET(FMT, ARG...)
#endif

#ifdef DEBUG_CALLS
#define LOG_CALL(f)                   AUDIODEV_DBG("Calling %s\n", f)
#define LOG_AND_CALL(x)               do {AUDIODEV_DBG("Calling %s ...", #x); x; TRACEDBG("done\n");} while(0)
#else
#define LOG_CALL(f)
#define LOG_AND_CALL(x)              do {x;} while(0)
#endif
#endif
